<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

use App\Helpers\Helper;

class Category extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];

    /**
     * Scope a query to only include active users.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeBaseResponse($query) {

        return $query->where('categories.status' , 1)
                    ->leftJoin('sub_categories' , 'categories.id' , '=' , 'sub_categories.category_id')
                    ->where('sub_categories.status' , 1)
                    ->groupBy('sub_categories.category_id')
                    ->havingRaw("COUNT(sub_categories.id) > 0")
                    ->orderBy('categories.name' , 'desc')
                    ->select('categories.id as category_id' , 'categories.name as category_name' , 'categories.description as category_description' , 'categories.picture as category_picture' , 'categories.unique_id' , 'categories.status');
    }
    
    public function subCategory() {
        return $this->hasMany('App\SubCategory' , 'category_id');
    }    

    public function providerSubscription() {
    	return $this->hasMany('App\ProviderSubscription' , 'category_id');
    }

    public static function boot() {

        //execute the parent's boot method 
        parent::boot();

        // delete your related models
        static::deleting(function($data) {

            Helper::delete_avatar('uploads/category' , $data->picture);

            // /** delete all subCategories belongs this category **/
            if(count($data->subCategory) > 0) {
                
                foreach($data->subCategory as $subCategories)
                {
                    $subCategories->delete();
                } 
            }
           
            // /** delete all provider subscriptions under this category **/
            if(count($data->providerSubscription) > 0) {

                foreach($data->providerSubscription as $providerSubscriptions)
                {
                    $providerSubscriptions->delete();
                }

            }   

        }); 

    }
}


