<?php

namespace App;

use App\Helpers\Helper;

use Illuminate\Database\Eloquent\Model;

use Log;

class EmailTemplate extends Model
{
    //

    public static function getRowValue($type, $receiver, $sender, $job) {

    	$model = self::where('type', $type)
                                        ->where('status', DEFAULT_TRUE)
                                        ->first();

        // \Log::info("Model Obj".print_r($model, true));

        if ($model) {

            $subject = $model->subject;

            $page = "admin.templates.email.email";

            $email = $receiver->email;

            \Log::info("Email ".$email);

            $model->content = html_entity_decode($model->content, ENT_COMPAT, 'UTF-8');

            Log::info("Email templates - CONTENt".print_r($model->content, true));

            // $sender_replaced = ($sender) ? str_replace('%&lt;$sender&gt;%',$sender->name, $model->content) : $model->content;

            $sender_replaced = ($sender) ? str_replace('%<$sender>%',$sender->name, $model->content) : $model->content;

            // $receiver_replaced = ($receiver) ? str_replace('%&lt;$receiver&gt;%',$receiver->name,$sender_replaced) : $sender_replaced;

            $receiver_replaced = ($receiver) ? str_replace('%<$receiver>%',$receiver->name,$sender_replaced) : $sender_replaced;

            // $job_replaced = ($job) ? str_replace('%&lt;$job&gt;%',$job->name,$receiver_replaced) : $receiver_replaced;

            $job_replaced = ($job) ? str_replace('%<$job>%',$job->name,$receiver_replaced) : $receiver_replaced;

            $message = $job_replaced;

            Log::info("Email templates - FINAL".print_r($model->message, true));

            $email_data = [];

            $email_data['message'] = $message;

            Helper::send_email($page,$subject,$email,$email_data);

            return $model->message;

        }

        return "";
    }
}
