<?php

use App\Helpers\Helper;

use Carbon\Carbon;

use App\Admin;

use App\User;

use App\Provider;

use App\MobileRegister;

use App\PageCounter;

use App\UserPayment;
     
use App\Settings;

use App\Activity;

use App\Category;

use App\SubCategory;

use App\ProviderService;

use App\Requests;

use App\RequestsMeta;

use App\RequestPayment;

use App\ProviderPayment;

use App\Page;

use App\Document;

use App\ProviderDocument;

use App\ChatMessage;

use App\Language;

use App\UserRating;

use App\ProviderRating;

use App\UserNotification;

use App\ProviderNotification;

use App\ProviderSubscription;

use App\ProviderSubscriptionPayment;

function tr($key , $other_key = "") {

    if(Auth::guard('admin')->check()) {

        $locale = config('app.locale');

    } else {

        if (!\Session::has('locale')) {

            $locale = \Session::put('locale', config('app.locale'));

        }else {

            $locale = \Session::get('locale');

        }
    }
    return \Lang::choice('messages.'.$key, 0, Array('other_key' => $other_key), $locale);
}

function register_mobile($device_type) {

    if($reg = MobileRegister::where('type' , $device_type)->first()) {
        $reg->count = $reg->count + 1;
        $reg->save();
    }
    
}

function get_admin_mail() {
    return Admin::first();
}

function get_document_types() {
    return Document::where('status' , 1)->get();
}

function get_provider_document($document_id , $provider_id) {
    return ProviderDocument::where('provider_id' , $provider_id)->where('document_id' , $document_id)->first();
}

function get_provider_amount($provider_id) {

    $completed_requests = Requests::where('provider_id' , $provider_id)->where('status' , REQUEST_COMPLETED)->with('payments')->get();

    $provider_amount = $completed_requests->sum('payments.provider_amount');

    $admin_amount = $completed_requests->sum('payments.admin_amount');

    $total = $completed_requests->sum('payments.total');

    $response = ['provider_amount' => $provider_amount , 'admin_amount' => $admin_amount , 'total' => $total ];

    return json_decode(json_encode($response));

}

function total_revenue() {
    
    $total = RequestPayment::sum('admin_amount');

    return $total ? $total : 0;
}

function get_register_count() {

    $ios_count = MobileRegister::where('type' , 'ios')->first()->count;

    $android_count = MobileRegister::where('type' , 'android')->first()->count;

    $web_count = MobileRegister::where('type' , 'web')->first()->count;

    $total = $ios_count + $android_count + $web_count;

    return array('total' => $total , 'ios' => $ios_count , 'android' => $android_count , 'web' => $web_count);

}

function last_days($days){

    $views = PageCounter::orderBy('created_at','asc')->where('created_at', '>', Carbon::now()->subDays($days))->where('page','home');
    $arr = array();
    $arr['count'] = $views->count();
    $arr['get'] = $views->get();

    return $arr;

}


function counter($page){

    $count_home = PageCounter::wherePage($page)->where('created_at', '>=', new DateTime('today'));

        if($count_home->count() > 0){
            $update_count = $count_home->first();
            $update_count->count = $update_count->count + 1;
            $update_count->save();
        }else{
            $create_count = new PageCounter;
            $create_count->page = $page;
            $create_count->count = 1;
            $create_count->save();
        }

}

function env_settings() {

    $path = base_path().'/.env';

    $data = array();

    if(file_exists($path)) {

            $values = file_get_contents($path);

            $values = explode("\n", $values);

            foreach ($values as $key => $value) {

                $var = explode('=',$value);

                if(count($var) ==  2) {
                    if($var[0] != "")
                        $data[$var[0]] = $var[1] ? $var[1] : null;
                } else {
                    if($var[0] != "")
                        $data[$var[0]] = null;
                }
            }

            array_filter($data);
    
    }

    return $data;

}

function envfile($search_key) {
    
    $data =  array();

    $path = base_path('.env');

    if(file_exists($path)) {

        $values = file_get_contents($path);

        $values = explode("\n", $values);

        foreach ($values as $key => $value) {

            $var = explode('=',$value);

            if(count($var) == 2 ) {
                if($var[0] != "")
                    $data[$var[0]] = $var[1] ? $var[1] : null;
            } else if(count($var) > 2 ) {
                $keyvalue = "";
                foreach ($var as $i => $imp) {
                    if ($i != 0) {
                        $keyvalue = ($keyvalue) ? $keyvalue.'='.$imp : $imp;
                    }
                }
                $data[$var[0]] = $var[1] ? $keyvalue : null;
            }else {
                if($var[0] != "")
                    $data[$var[0]] = null;
            }
        }

        array_filter($data);
    
    }


    if($data) {
        return $data[$search_key];
    }

    return "";

}

// Based on the job type, it will return string value for that job type

function job_type($job_type) {

    if($job_type == REQUEST_NOW) {
        $string = tr('request_now');
    } else {
        $string = tr('request_later');
    }

    return $string;
}
// Based on the price type, it will return string value for that job type

function price_type($price_type = PRICE_TYPE_HOUR_BASED) {

    if($price_type == PRICE_TYPE_HOUR_BASED) {

        $string = tr('PRICE_TYPE_HOUR_BASED');

    } elseif ($price_type == PRICE_TYPE_FIXED_BASED) {

        $string = tr('PRICE_TYPE_FIXED_BASED');

    } else {

        $string = tr('PRICE_TYPE_HOUR_BASED');

    }

    return $string;
}

// Based on the request type, it will return string value for that request type

function request_type($request_type) {
    
    if($request_type == REQUEST_TYPE_LOCATION) {
        $string = tr('request_type_location');
    } elseif($request_type == REQUEST_TYPE_CATEGORY) {
        $string = tr('request_type_category');
    } else {
        $string = tr('request_type_direct');
    }

    return $string;
}

/**
 * 
 *
 */

function user_timezone($data , $timezone="") {

    if($timezone) {

        $data = convertTimeToUSERzone($data , $timezone);
    }

    return date('d-m-Y H:i' , strtotime($data));
}

function common_date($date , $timezone = "Asia/Kolkata") {

    if($timezone) {

        $date = convertTimeToUSERzone($date , $timezone);

    }

    return date('d M Y h:i A' , strtotime($date));
}

/**
 * @method common_date()
 *
 * @uses to return server date
 *
 * @created 
 * 
 * @updated Anjana H
 * 
 * @param $date, $timezone, $format
 * 
 * @return date
 */
function common_server_date($date , $timezone = "" , $format = "d M Y h:i A") {

    if($date == "0000-00-00 00:00:00" || $date == "0000-00-00" || !$date) {

        return $date = '';
    }

    if($timezone) {

        $date = convertTimeToUTCzone($date, $timezone, $format);

    }

    return $timezone ? $date : date($format, strtotime($date));

}


function get_request_status($status , $provider_status) {

    if($status == REQUEST_CREATED && $provider_status == PROVIDER_NONE) {
        $result = tr('created');
    } 

    elseif ($status == REQUEST_WAITING && $provider_status == PROVIDER_NONE) {
        $result = tr('waiting');
    } 

    elseif ($status == REQUEST_PROVIDER_ASSIGNED && $provider_status == PROVIDER_ASSIGNED) {
        $result = tr('provider_assigned');
    } 

    elseif ($status == REQUEST_ONGOING && $provider_status == PROVIDER_ACCEPTED) {

        $result = tr('booked');
    } 

    elseif ($status == REQUEST_ONGOING && $provider_status == PROVIDER_STARTED) {

        $result = tr('PROVIDER_STARTED');

    } 

    elseif ($status == REQUEST_ONGOING && $provider_status == PROVIDER_ARRIVED) {
        
        $result = tr('PROVIDER_ARRIVED');
    } 

    elseif ($status == REQUEST_ONGOING && $provider_status == PROVIDER_SERVICE_STARTED) {
       
        $result = tr('PROVIDER_SERVICE_STARTED');
        
    } 

    elseif ($status == REQUEST_COMPLETE_PENDING && $provider_status == PROVIDER_SERVICE_COMPLETED) {

        $result = tr('PROVIDER_SERVICE_COMPLETED');

    } 

    elseif ($status == WAITING_PAYMENT_CONFIRM && $provider_status == PROVIDER_SERVICE_COMPLETED) {
        $result = tr('WAITING_PAYMENT_CONFIRM');
    } 

    elseif ($status == REQUEST_RATING) {
        $result = tr('REQUEST_RATING');
    }

    elseif ($status == REQUEST_COMPLETED) {
        $result = tr('REQUEST_COMPLETED');
    } else {
        $result = "None";
        $tracking_status = 'None';
    }

    $response = ['status' => $result,'tracking_status' => $tracking_status];

    return json_decode(json_encode($response));

}

/**
 * Function used to web request tracking in single job details
 *
 * @param integer $status integer $provider_status
 * 
 * @return array $tracking 
 */

function tracking($status, $provider_status) {

    $tracking = ['created' => 0 , 'provider_assigned' => 0 , 'booked' => 0 , 'provider_started' => 0 , 'ongoing' => 0 , 'finished' => 0];

    if(in_array($status, [REQUEST_NONE,REQUEST_CREATED,REQUEST_WAITING]) && $provider_status == PROVIDER_NONE) {
        $tracking['created'] = 1;
    } 
    elseif($status == REQUEST_PROVIDER_ASSIGNED && $provider_status == PROVIDER_ASSIGNED) {
        $tracking['created'] = 2;
        $tracking['provider_assigned'] = 1;
    }
    elseif($status == REQUEST_ONGOING && $provider_status == PROVIDER_ACCEPTED) {
        $tracking['created'] = 2;
        $tracking['provider_assigned'] = 2;
        $tracking['booked'] = 1;
    }

    elseif($status == REQUEST_ONGOING && $provider_status == PROVIDER_STARTED) {
        $tracking['created'] = 2;
        $tracking['provider_assigned'] = 2;
        $tracking['booked'] = 2;
        $tracking['provider_started'] = 1;
    }
    elseif(in_array($status , [REQUEST_ONGOING , REQUEST_COMPLETE_PENDING,WAITING_PAYMENT_CONFIRM,REQUEST_RATING]) && !in_array($provider_status ,[ PROVIDER_ACCEPTED , PROVIDER_STARTED])) {
        $tracking['created'] = 2;
        $tracking['provider_assigned'] = 2;
        $tracking['booked'] = 2;
        $tracking['provider_started'] = 2;
        $tracking['ongoing'] = 1;
    }
    elseif($status == REQUEST_COMPLETED) {
        $tracking['created'] = 2;
        $tracking['provider_assigned'] = 2;
        $tracking['booked'] = 2;
        $tracking['provider_started'] = 2;
        $tracking['ongoing'] = 2;
        $tracking['finished'] = 1;
    }

    return $tracking;

}

/**
 *
 */

function request_meta_status($id) {
    $status = [
        tr('REQUEST_META_NONE'), 
        tr('REQUEST_META_OFFERED'),
        tr('REQUEST_META_BID'), 
        tr('REQUEST_META_ASSIGNED'), 
        tr('REQUEST_META_TIMEDOUT')
    ];

    return $status[$id];
}

function request_step($id) {

    $status = [
        tr('REQUEST_STEP_1'), 
        tr('REQUEST_STEP_2'),
        tr('REQUEST_STEP_3'), 
        tr('REQUEST_STEP_4'), 
        tr('REQUEST_STEP_5'),
        tr('REQUEST_STEP_FINAL')
    ];

    return $status[$id];
    
}

/**
 * Used to get request status
 *
 */

function request_status($id) {
    $status = [
        tr('REQUEST_NONE'), 
        tr('REQUEST_CREATED'),
        tr('REQUEST_WAITING'), 
        tr('REQUEST_PROVIDER_ASSIGNED'), 
        tr('REQUEST_ONGOING'), 
        tr('REQUEST_COMPLETE_PENDING'),
        tr('WAITING_PAYMENT_CONFIRM'),
        tr('REQUEST_RATING'), 
        tr('REQUEST_COMPLETED'), 
        tr('REQUEST_CANCELLED'), 
        tr('REQUEST_NO_PROVIDER_AVAILABLE'), 
        tr('REQUEST_TIME_EXCEED_CANCELLED'), 
    ];

    return $status[$id];
}

/**
 * Used to get request provider status
 *
 */

function provider_status($id) {

    $status = [
        tr('PROVIDER_NONE'),
        tr('PROVIDER_ASSIGNED'), 
        tr('PROVIDER_ACCEPTED'), 
        tr('PROVIDER_STARTED'), 
        tr('PROVIDER_ARRIVED'),
        tr('PROVIDER_SERVICE_STARTED'),
        tr('PROVIDER_SERVICE_COMPLETED'),
        tr('PROVIDER_RATED'),
    ];

    return $status[$id];
}


/**
 * @method getCategories()
 * @uses To load categories which is created by admin
 * 
 * @return json array objects
 */
function getCategories() {
    
    // Load categroies model
    $data = Category::where('categories.status' , 1)
            ->select('categories.id as category_id' , 'categories.name as category_name' , 'categories.description as category_description' , 'categories.picture as category_picture' , 'categories.unique_id' , 'categories.status')
            ->leftJoin('sub_categories' , 'categories.id' , '=' , 'sub_categories.category_id')
            ->where('sub_categories.status' , 1)
            ->groupBy('sub_categories.category_id')
            ->havingRaw("COUNT(sub_categories.id) > 0")
            ->get();

    // return array of objects 

    return $data;
} 

/**
 * @method getSubCategories()
 * @uses To load subcategories which is created by admin based on category
 *
 * @return json array objects
 */
function getSubCategories($request) {
    // Load subcategories
    $data = SubCategory::where('category_id' , $request->category_id)
                ->select('category_id','id as sub_category_id' , 'name as sub_category_name' , 'description as sub_category_description' , 'picture as sub_category_picture' , 'unique_id' , 'status' , 'sub_categories.price')
                ->where('status' , APPROVED)
                ->get();
    // Return array of objects
    return $data;
}

/**
 *
 *
 */
function get_category_details($category_id) {

    return Category::find($category_id);
}

/**
 * check the provider has already updated the services
 * 
 *
 */

function check_provider_service($provider_id,$sub_category_id) {
    return ProviderService::where('provider_id' , $provider_id)->where('sub_category_id' , $sub_category_id)->where('status' , APPROVED)->first();
}


function selected_service_categories($id) {

    $model = ProviderService::where('provider_id', $id)->where('status' , APPROVED)->groupBy('category_id')->get()->pluck('category_id')->toArray();

    return $model;

}

function get_recent_users() {

    $users = User::orderBy('created_at' , 'desc')
                ->where('login_status','user')->skip(0)->take(12)
                ->get();

    return $users;
}

/**
 * Get provider details
 *
 */

function provider_details($id) {
    return Provider::find($id);
}

/**
 * Get Request meta details
 *
 */

function get_requests_meta($request_id,$provider_id) {

    return RequestsMeta::where('provider_id' , $provider_id)->where('request_id' , $request_id)->first();
}

function page_details() {
    
    $pages = Page::where('type','=','others')->get();
    
    return $pages;
}

function get_page($type) {
    $page = Page::where('type','terms')->first();

    return $page;

}

//this function convert string to UTC time zone

function convertTimeToUTCzone($str, $userTimezone, $format = 'Y-m-d H:i:s') {

    try {
        $new_str = new DateTime($str, new DateTimeZone($userTimezone));

        $new_str->setTimeZone(new DateTimeZone('UTC'));
    }
    catch(\Exception $e) {

    }

    return $new_str->format( $format);
}

//this function converts string from UTC time zone to current user timezone

function convertTimeToUSERzone($str, $userTimezone, $format = 'Y-m-d H:i:s') {

    if(empty($str)){
        return '';
    }
    try{

        $new_str = new DateTime($str, new DateTimeZone('UTC') );

        $new_str->setTimeZone(new DateTimeZone( $userTimezone ));
        
    }
    catch(\Exception $e) {
        // Do Nothing
    }
    
    return $new_str->format( $format);
}

/**
 * Check the user has sent any messages to that provider
 *
 */

function check_provider_chat($user_id , $provider_id , $request_id) {

    // Log::info("check_provider_chat ----- user_id".print_r($user_id , true));

    // Log::info("check_provider_chat ----- provider_id".print_r($provider_id, true));

    // Log::info("check_provider_chat ----- request_id".print_r($request_id, true));

    $data = ChatMessage::where('user_id' , $user_id)->where('provider_id', $provider_id)->where('request_id' , $request_id)->where('type' , 'up')->count();

    // Log::info("check_provider_chat".print_r($data , true));

    return $data;
}



function readFileLength($file)  {

    $variableLength = 0;
    if (($handle = fopen($file, "r")) !== FALSE) {
         $row = 1;
         while (($data = fgetcsv($handle, 1000, "\n")) !== FALSE) {
            $num = count($data);
            $row++;
            for ($c=0; $c < $num; $c++) {
                $exp = explode("=>", $data[$c]);
                if (count($exp) == 2) {
                    $variableLength += 1; 
                }
            }
        }
        fclose($handle);
    }

    return $variableLength;
}

function getActiveLanguages() {
    return Language::where('status', DEFAULT_TRUE)->get();
}

function user_rating($user_id) {

    return UserRating::where('user_id', $user_id)->avg('rating') ? : 1;
}

function provider_rating($provider_id) {
    
    return ProviderRating::where('provider_id', $provider_id)->avg('rating') ? : 1;
}

function get_user_notifications() {

    $model = UserNotification::select('user_notifications.id as notify_id', 
            'user_notifications.notification as notification', 
            'providers.picture as picture',
            'providers.name as name',
            'user_notifications.provider_id as provider_id',
            'user_notifications.request_id as request_id',
            'requests.unique_id as unique_id',
            'user_notifications.created_at as created_at')
        ->where('user_notifications.user_id', Auth::user()->id)
        ->leftJoin('providers', 'providers.id', '=', 'user_notifications.provider_id')
        ->leftJoin('requests', 'requests.id', '=', 'user_notifications.request_id')
        ->orderBy('created_at', 'desc')
        ->skip(0)->take(21)->get();


    $new_notify = UserNotification::where('user_id', Auth::user()->id)->where('status', DEFAULT_FALSE)->count();

    return ['model'=> $model, 'new_notify'=>$new_notify];
}

function get_provider_notifications() {

    $model = ProviderNotification::select('provider_notifications.id as notify_id', 
            'provider_notifications.notification as notification', 
            'users.picture as picture',
            'users.name as name',
            'provider_notifications.user_id as user_id',
            'provider_notifications.request_id as request_id',
            'requests.unique_id as unique_id',
            'provider_notifications.created_at as created_at')
        ->where('provider_notifications.provider_id', Auth::guard('provider')->user()->id)
        ->leftJoin('users', 'users.id', '=', 'provider_notifications.user_id')
        ->leftJoin('requests', 'requests.id', '=', 'provider_notifications.request_id')
        ->orderBy('created_at', 'desc')->skip(0)->take(20)->get();

    $new_notify = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)->where('status', DEFAULT_FALSE)->count();

    return ['model'=> $model, 'new_notify'=>$new_notify];
}

function new_job_notifications() {

    $new_notify = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)->where('status', DEFAULT_FALSE)->where('job_status', DEFAULT_TRUE)->count();

    return $new_notify;

}

function direct_job_notifications() {

    $direct_notify = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)
                ->where('status', DEFAULT_FALSE)
                ->where('job_status', 2)->count();

    return $direct_notify;

}


function confirmed_job_notifications() {

    $confirmed = UserNotification::where('user_id', Auth::user()->id)
                ->where('status', DEFAULT_FALSE)
                ->where('job_status', 1)->count();

    return $confirmed;

}

function ongoing_job_notifications() {

    $ongoing = UserNotification::where('user_id', Auth::user()->id)
                ->where('status', DEFAULT_FALSE)
                ->where('job_status', 2)->count();

    return $ongoing;

}


function bidded_job_notifications() {

    $direct_notify = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)
                ->where('status', DEFAULT_FALSE)
                ->where('job_status', 3)->count();

    return $direct_notify;

}

// Based on the request type, it will return string value for that request type

function redeem_request_status($status) {
    
    if($status == REDEEM_REQUEST_SENT) {
        $string = tr('REDEEM_REQUEST_SENT');
    } elseif($status == REDEEM_REQUEST_PROCESSING) {
        $string = tr('REDEEM_REQUEST_PROCESSING');
    } elseif($status == REDEEM_REQUEST_PAID) {
        $string = tr('REDEEM_REQUEST_PAID');
    } elseif($status == REDEEM_REQUEST_CANCEL) {
        $string = tr('REDEEM_REQUEST_CANCEL');
    } else {
        $string = tr('REDEEM_REQUEST_SENT');
    }

    return $string;

}

function get_user_timezone($id) {

    if($user = User::find($id)) {

        return $user->timezone;
    }

    return "";
}


function get_provider_timezone($id) {

    if($provider = Provider::find($id)) {
        
        return $provider->timezone;
    }
    return "";
}

/**
 * @method showEntries()
 *
 * @uses To load the entries of the row
 *
 * @created Maheswari
 *
 * @updated Maheswari
 *
 * @return reponse of serial number
 */
function showEntries($request, $i) {

    $s_no = $i;

    // Request Details + s.no

    if (isset($request['page'])) {

        $s_no = (($request['page'] * 10) - 10 ) + $i;

    }

    return $s_no;

}


/**
* @method routefreestring()
*
* @uses to remove the route parameters from the string
*
* @created Maheswari S
*
* @updated Maheswari S
*
* @param string $string
*
* @return Route parameters free string
*/
function routefreestring($string) {

    $search = array(' ', '&', '%', "?",'=','{','}','$');

    $replace = array('-', '-', '-' , '-', '-', '-' , '-','-');

    $string = str_replace($search, $replace, $string);

    return $string;
}

function amount_convertion($percentage, $amt) {

    $converted_amt = $amt * ($percentage/100);

    return $converted_amt;
}

/**
 * @method last_x_days_revenue()
 *
 * @uses to get revenue analytics 
 *
 * @created Anjana H
 * 
 * @updated Anjana H
 * 
 * @param  integer $days
 * 
 * @return array of revenue totals
 */
function last_x_days_revenue($days) {
            
    $data = new \stdClass;

    $data->currency = $currency = Setting::get('currency', '$');
  
    // Today Earnings
    
    $today_earnings = RequestPayment::whereDate('paid_date', '=',date('Y-m-d'))->where('is_paid' , YES)->sum('provider_amount');

    $data->today_earnings = $today_earnings ?: 0.00; 

    $data->today_earnings_formatted = $currency." ".$data->today_earnings ?: 0.00; 

    // TRIPS DETAILS

    // total_upcoming_jobs

    $total_upcoming_jobs = Requests::where('job_type' , REQUEST_LATER)->whereIn('status' , [REQUEST_ONGOING])->whereIn('provider_status' , [PROVIDER_ACCEPTED])->count();

    $data->total_upcoming_jobs = $total_upcoming_jobs ?: 0;

    // total_completed_jobs

    $total_completed_jobs = Requests::whereIn('status' , [REQUEST_RATING , REQUEST_COMPLETED])
                ->where('provider_status' , PROVIDER_RATED)
                ->count();

    $data->total_completed_jobs = $total_completed_jobs ?: 0;

    // total_cancelled_jobs

    $total_cancelled_jobs = Requests::whereIn('status' , [REQUEST_CANCELLED , REQUEST_TIME_EXCEED_CANCELLED])
                ->count();

    $data->total_cancelled_jobs = $total_cancelled_jobs ?: 0;

    // Last 10 days revenues

    $last_x_days_revenues = [];

    $start  = new \DateTime('-10 days', new \DateTimeZone('UTC'));

    $period = new \DatePeriod($start, new \DateInterval('P1D'), 10);

    $dates = $last_x_days_revenues = [];

    foreach ($period as $date) {

        $current_date = $date->format('Y-m-d');

        $last_x_days_data = new \stdClass;

        $last_x_days_data->date = $current_date;
      
        $last_x_days_total_request_earnings = RequestPayment::whereDate('paid_date', '=', $current_date)->where('is_paid' , YES)->sum('provider_amount');

        $last_x_days_total_provider_pubscription_earnings = ProviderSubscriptionPayment::whereDate('created_at', '=', $current_date)->sum('paid_amount');
      
        $last_x_days_data->total_earnings = $last_x_days_total_request_earnings + $last_x_days_total_provider_pubscription_earnings ?: 0.00;

        $last_x_days_data->total_earnings_formatted = $currency." ".$last_x_days_data->total_earnings ?: 0.00;

        array_push($last_x_days_revenues, $last_x_days_data);
    }

    $data->last_x_days_revenues = $last_x_days_revenues;

    return $data;

}

/**
 * @method formatted_amount()
 *
 * @uses to format the number
 *
 * @created vidhya R
 *
 * @updated vidhya R
 *
 * @param integer $num
 *
 * @param string $currency
 *
 * @return string $formatted_amount
 **/
function formatted_amount($amount = 0.00, $currency = "") {

    $currency = $currency ?: Setting::get('currency', '$');

    $formatted_amount = $currency."".$amount;

    return $formatted_amount;

}

/**
 * @method is_category_subscription()
 *
 * @uses To check the provider subscribed on category and subscription expiery date
 *
 * @created Anjana H
 *
 * @updated Anjana H
 *
 * @param Integer provider_id, category_id
 *
 * @return TRUE/FALSE 
 **/
function is_category_subscription($category_id) {

    $subscriptions = ProviderSubscription::where('category_id', $category_id)
                               // ->whereDate('expiry_date', '>=', date('Y-m-d H:i:s'))
                               ->count();
   
    $has_subscriptions = $subscriptions ?: NO; 
   
    return $has_subscriptions;
}

/**
 * @method check_provider_subscribed_category()
 *
 * @uses To check the provider subscribed on category and subscription expiery date
 *
 * @created Anjana H
 *
 * @updated Anjana H
 *
 * @param Integer provider_id, category_id
 *
 * @return TRUE/FALSE 
 **/
function check_provider_subscribed_category($provider_id, $category_id) {

    $has_paid_subscriptions = ProviderSubscriptionPayment::where('provider_id', $provider_id)
                        ->leftJoin('provider_subscriptions','provider_subscriptions.id' ,'=', 'provider_subscription_payments.provider_subscription_id')
                        ->where('provider_subscriptions.category_id','=',$category_id)
                        ->where('provider_subscription_payments.status', PAID)
                        ->whereDate('provider_subscription_payments.expiry_date', '>=', date('Y-m-d H:i:s'))
                        ->where('provider_subscription_payments.is_current_subscription','=', YES)
                        ->count();

    $is_subscribed = $has_paid_subscriptions ?: NO; 

    return $is_subscribed;

}

/**
 * @method get_category_subscribed_provider()
 *
 * @uses get category subscribed providers list whos subscription not expired
 *
 * @created Anjana H
 *
 * @updated Anjana H
 *
 * @param Integer category_id
 *
 * @return array of category subscribed providers
 **/
function get_category_subscribed_providers($category_id) {

    $category_subscribed_providers = ProviderSubscriptionPayment::
                        leftJoin('provider_subscriptions','provider_subscriptions.id' ,'=', 'provider_subscription_payments.provider_subscription_id')
                        ->where('provider_subscriptions.category_id', $category_id)
                        ->where('provider_subscription_payments.status', PAID)
                        ->whereDate('provider_subscription_payments.expiry_date', '>=', date('Y-m-d H:i:s'))
                        ->where('provider_subscription_payments.is_current_subscription','=', YES)
                        ->pluck('provider_subscription_payments.provider_id');

    return $category_subscribed_providers;

}
