<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Excel;

use App\User;

use App\Requests;

use App\RequestPayment;

use App\Provider;

use Exception;

use Setting;

class AdminExportController extends Controller
{
   	/**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('admin');  
    }
    
    /**
	 * @method users_export()
	 *
	 * @uses to export the users details into the selected format
	 *
	 * @created Maheswari S
	 *
	 * @updated Maheswari S
	 *
	 * @param string format (xls, csv or pdf)
	 *
	 * @return redirect users page with success or error message 
	 */
    public function users_export(Request $request) {

    	try {

    		// Get the admin selected format for download

    		$format = $request->format ? $request->format : 'xlsx';

	    	$download_filename = routefreestring(Setting::get('site_name'))."-".date('Y-m-d-h-i-s')."-".uniqid();

	    	$result = User::orderBy('created_at' , 'desc')->get();

	    	// Check the result is not empty

	    	if(count($result) == 0) {
            	
            	return redirect()->route('admin.users.index')->with('flash_error' , tr('no_user_found'));

	    	}

	    	Excel::create($download_filename, function($excel) use($result)
		    {

		        $excel->sheet('USERS', function($sheet) use($result) 
		        {

	 				$sheet->row(1, function($first_row) {

	                    $first_row->setAlignment('center');

	                });

	                $sheet->setHeight(50);

					$sheet->setAutoSize(true);

					$sheet->setAllBorders('thin');
			        
			        $sheet->setFontFamily('Comic Sans MS');

					$sheet->setFontSize(15);
				
					// Set height for a single row

		    		$sheet->setAutoFilter();

		    		$title = tr('users_management');
		    		
			        $sheet->loadView('exports.users')->with('data' , $result)->with('title' , $title);

			    });
		    
		    })->export($format);

            return redirect()->route('admin.users.index')->with('flash_success' , tr('export_success'));

		} catch(\Exception $e) {

            $error = $e->getMessage();

            return redirect()->route('admin.users.index')->with('flash_error' , $error);

        }

    }


     /**
	 * @method providers_export()
	 *
	 * @uses to export the provider details into the selected format
	 *
	 * @created Maheswari S
	 *
	 * @updated Maheswari S
	 *
	 * @param string format (xls, csv or pdf)
	 *
	 * @return redirect provider page with success or error message 
	 */
    public function providers_export(Request $request) {

    	try {

    		// Get the admin selected format for download

    		$format = $request->format ? $request->format : 'xls';

	    	$download_filename = routefreestring(Setting::get('site_name'))."-".date('Y-m-d-h-i-s')."-".uniqid();

	    	$result = Provider::orderBy('created_at' , 'desc')->get();

	    	// Check the result is not empty

	    	if(count($result) == 0) {
            	
            	return redirect()->route('admin.providers.index')->with('flash_error' , tr('provider_not_found'));

	    	}

	    	Excel::create($download_filename, function($excel) use($result)
		    {

		        $excel->sheet('PROVIDER', function($sheet) use($result) 
		        {

	 				$sheet->row(1, function($first_row) {

	                    $first_row->setAlignment('center');

	                });

	                $sheet->setHeight(50);

					$sheet->setAutoSize(true);

					$sheet->setAllBorders('thin');
			        
			        $sheet->setFontFamily('Comic Sans MS');

					$sheet->setFontSize(15);
				
					// Set height for a single row

		    		$sheet->setAutoFilter();

		    		$title = tr('provider_management');
		    		
			        $sheet->loadView('exports.providers')->with('data' , $result)->with('title' , $title);

			    });
		    
		    })->export($format);

            return redirect()->route('admin.providers.index')->with('flash_success' , tr('export_success'));

		} catch(\Exception $e) {

            $error = $e->getMessage();

            return redirect()->route('admin.providers.index')->with('flash_error' , $error);

        }

    }


    /**
	 * @method requests_export()
	 *
	 * @uses to export the later/ondemand request details into the selected format
	 *
	 * @created Maheswari S
	 *
	 * @updated Maheswari S
	 *
	 * @param string format(xls, csv or pdf), job type for later/ondemand
	 *
	 * @return redirect requests on ondemand/later page with success/error message 
	 */
    public function requests_export(Request $request) {

    	try {

    		// Get the admin selected format for download

    		$format = $request->format ? $request->format : 'xlsx';

	    	$download_filename = routefreestring(Setting::get('site_name'))."-".date('Y-m-d-h-i-s')."-".uniqid();

	    	// Checked here later or ondemand request

	    	if($request->job_type == REQUEST_NOW ){

	    		$requests_details = Requests::where('job_type' , REQUEST_NOW);

	    	} else{

	    		$requests_details = Requests::where('job_type' , REQUEST_LATER);
	    	}

	    	$result = $requests_details->orderBy('updated_at' , 'desc')->get();
	    	

	    	// Check the result is not empty

	    	if(count($result) == 0) {

	    		// Checked here later or ondemand request

	    		if($request->job_type == REQUEST_NOW){
            	
            		return redirect()->route('admin.requests.ondemand')->with('flash_error' , tr('request_not_found'));
            	} else {

					return redirect()->route('admin.requests.bidding')->with('flash_error' , tr(	'request_not_found'));

            	}

	    	}

	    	Excel::create($download_filename, function($excel) use($result)
		    {

		        $excel->sheet('REQUEST', function($sheet) use($result) 
		        {

	 				$sheet->row(1, function($first_row) {

	                    $first_row->setAlignment('center');

	                });

	                $sheet->setHeight(50);

					$sheet->setAutoSize(true);

					$sheet->setAllBorders('thin');
			        
			        $sheet->setFontFamily('Comic Sans MS');

					$sheet->setFontSize(15);
				
					// Set height for a single row

		    		$sheet->setAutoFilter();

		    		$title = tr('request_management');
		    		
			        $sheet->loadView('exports.requests')->with('data' , $result)->with('title' , $title);

			    });
		    
		    })->export($format);

	    	// Checked here later or ondemand request
	    	
		    if($request->job_type == REQUEST_NOW){

            	return redirect()->route('admin.requests.ondemand')->with('flash_success' , tr('export_success'));
            } else {

            	return redirect()->route('admin.requests.bidding')->with('flash_success' , tr('export_success'));

            }

		} catch(\Exception $e) {

            $error = $e->getMessage();

            // Checked here later or ondemand request

            if($request->job_type == REQUEST_NOW) {

            	return redirect()->route('admin.requests.ondemand')->with('flash_error' , $error);

            } else {

            	return redirect()->route('admin.requests.bidding')->with('flash_error' , $error);

            }

        }

    }

     /**
	 * @method payments_export()
	 *
	 * @uses to export the payment details into the selected format
	 *
	 * @created Maheswari S
	 *
	 * @updated Maheswari S
	 *
	 * @param string format(xls, csv or pdf)
	 *
	 * @return redirect request payment page with success or error message 
	 */
    public function payments_export(Request $request) {

    	try {

    		// Get the admin selected format for download

    		$format = $request->format ? $request->format : 'xls';

	    	$download_filename = routefreestring(Setting::get('site_name'))."-".date('Y-m-d-h-i-s')."-".uniqid();

			$result = RequestPayment::orderBy('created_at' , 'desc')->get();

	    	// Check the result is not empty

	    	if(count($result) == 0) {
            	
            	return redirect()->route('admin.user.payments')->with('flash_error' , tr('payment_not_found'));

	    	}

	    	Excel::create($download_filename, function($excel) use($result)
		    {

		        $excel->sheet('REQUEST', function($sheet) use($result) 
		        {

	 				$sheet->row(1, function($first_row) {

	                    $first_row->setAlignment('center');

	                });

	                $sheet->setHeight(50);

					$sheet->setAutoSize(true);

					$sheet->setAllBorders('thin');
			        
			        $sheet->setFontFamily('Comic Sans MS');

					$sheet->setFontSize(15);
				
					// Set height for a single row

		    		$sheet->setAutoFilter();

		    		$title = tr('payment_management');
		    		
			        $sheet->loadView('exports.payments')->with('data' , $result)->with('title' , $title);

			    });
		    
		    })->export($format);

            return redirect()->route('admin.user.payments')->with('flash_success' , tr('export_success'));

		} catch(\Exception $e) {

            $error = $e->getMessage();

            return redirect()->route('admin.user.payments')->with('flash_error' , $error);

        }

    }
}
