<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Requests;

use App\RequestsMeta;

use App\RequestPayment;

use App\TempRequests;

use App\Helpers\Helper;

use App\Repositories\CommonRepository as CommonRepo;

use App\Jobs\sendPushNotification;

use Setting;

use App\Page;

use App\User;

use App\Provider;

use App\Settings;

use App\Category;

use App\SubCategory;

use App\BannerImage;

use App\ChatMessage;

use App\ProviderSubscriptionPayment;

use Log;

use Auth;

use DB;

use Exception;

use Validator;

class ApplicationController extends Controller
{
    public function __construct(Request $request) {

        $this->middleware('AddHeader' , array('only' => ['categories' , 'sub_categories' ]));

    }
    
    /**
     * @method home()
     *
     * Index or Landing page of the site
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param
     *
     * @return redirect to view page
     */

    public function home(Request $request) {

    	// Increase the site view count

        counter('home');

        if(\Auth::check()) {

            return redirect()->route('user.dashboard');

        } else {

        	$banner_image = BannerImage::get();

            $sub_categories = SubCategory::where('status' , COMMON_APPROVED)->orderBy(\DB::raw('RAND()'))->skip(0)->take(3)->get();

	        // $categories = Category::take(3)
	        //     ->leftJoin('sub_categories' , 'categories.id' , '=' , 'sub_categories.category_id')
	        //     ->where('sub_categories.status' , 1)
	        //     ->groupBy('sub_categories.category_id')
	        //     ->havingRaw("COUNT(sub_categories.id) > 0")
	        //     ->get();

            return view('static.home')->with('banner_image',$banner_image)->with('sub_categories' , $sub_categories);
 
        }
    
    }

    /** 
     * Choose whether user or provider
     * 
     */

    public function choose_register(Request $request) {
        return view('user.auth.choose_register');
    }

    /** 
     * Choose login or register in user
     * 
     */

    public function user_choose_login(Request $request) {
        return view('user.auth.choose_login_signup');
    }

    /** 
     * Choose login or register in Provider
     * 
     */

    public function provider_choose_login(Request $request) {
        return view('provider.auth.choose_login_signup');
    }

    /**
     * How It Works of the site
     *
     *
     */

    public function how_it_works(Request $request) {
        return view('static.how-its-works');
    }

    /**
     * Terms of the site
     *
     *
     */

    public function terms(Request $request) {

       $page = Page::where('type','terms')->first();
        
        return view('static.static_page')->withPage($page);
    
    }

    /**
     * contact of the site
     *
     *
     */

    public function contact(Request $request) {
    
        $page = Page::where('type','contact')->first();

        return view('static.static_page')->withPage($page);
   
    }
    /**
     * Help of the site
     *
     *
     */

    public function static_help(Request $request) {
    
        $page = Page::where('type','help')->first();

        return view('static.static_page')->withPage($page);
   
    }

    /**
     * FAQ of the site
     *
     *
     */

    public function static_faq(Request $request) {
    
        $page = Page::where('type','faq')->first();

        return view('static.static_page')->withPage($page);
   
    }

    /**
     * privacy of the site
     *
     *
     */

    public function privacy(Request $request) {
        
        $page = Page::where('type','privacy')->first();
        
        return view('static.static_page')->withPage($page);
    
    }

    /**
     * about of the site
     *
     *
     */

    public function about(Request $request) {
        
        $page = Page::where('type','about')->first();
        
        return view('static.static_page')->withPage($page);
    
    }

    /**
     * Other Pages of the site
     *
     *
     */

    public function other_pages(Request $request) {

        $page = Page::where('unique_id',$request->unique_id)->first();
  
        return view('static.static_page')->withPage($page);
    
    }

    public function static_page(Request $request) {

        $validator = \Validator::make($request->all() , [
                'page_type' => 'required',
            ]);

        $page_data['page_type'] = $page_data['heading'] = $page_data['content'] = "";

        $page = Page::where('type', $request->page_type)->first();

        if($page) {
            
            $page_data['page_type'] = $request->page_type;
            $page_data['heading'] = $page->heading;
            $page_data ['content'] = $page->description;
        }

        $response_array = array('success' => true , 'page' => $page_data);

        return response()->json($response_array,200);

    }

    /**
     * @method categories()
     *
     * To load only categories
     *
     * @return categories
     */

    public function categories(Request $request) {

        // Load Categories
        $data = getCategories();

        // Map the array values using helper
        $response_array = array('success' => true , 'data' => Helper::null_safe($data));

        // Convert array of objects into JSON array
        return response()->json($response_array, 200);
    }

    /**
     * @method sub_categories()
     * 
     * @uses To load sub categories value based on category id
     *
     * @return sub category values
     */
    
    public function sub_categories(Request $request) {
        // Get sub categories
        $data = getSubCategories($request);

        \Log::info("getSubCategories".print_r($data , true));

        // Map the array of values using helper
        $response_array = array('success' => true , 'data' => Helper::null_safe($data));

         \Log::info("getSubCategories Response array".print_r($response_array , true));
        // Convert array of objects into JSON array
        return response()->json($response_array, 200);
    }

    public function get_payment_modes(Request $request) {

        $payment_modes = [];

        $modes = Settings::whereIn('key' , array('cod','paypal','card'))->where('value' , 1)->get();

        if($modes) {

            foreach ($modes as $key => $mode) {
                $payment_modes[$mode->key] = $mode->key;
            }            
        }

        $payment_modes = Helper::null_safe($payment_modes);

        $response_array = ['success' => true , 'payment_modes' => $payment_modes];

        return response()->json($response_array,200);
    
    }

    public function assign_next_provider_cron() {

        Log::info("ASSIGN PROVIDER CRON STARTED");

        $provider_timeout = Setting::get('provider_timeout' , 100);

        $time = date("Y-m-d H:i:s");

        //Get all the new waiting requests which are not confirmed and not cancelled.
        $query = "SELECT id, user_id,request_type,provider_id, TIMESTAMPDIFF(SECOND,request_start_time, '$time') AS time_since_request_assigned
                  FROM requests
                  WHERE status = ".REQUEST_CREATED." and job_type = ".REQUEST_NOW;
                  
        $requests = \DB::select(\DB::raw($query));

        Log::info(print_r($requests , true));

        foreach($requests as $request) {

            if($request->time_since_request_assigned >= $provider_timeout) {

                $current_offered_provider = RequestsMeta::where('request_id',$request->id)->where('status', REQUEST_META_OFFERED)->first();

                $provider_id = array();

                if($current_offered_provider) {

                    #check provider is subscribed to category subscriptions AND expiry date for subscription

                    // $has_subscriptions = is_category_subscription($request->category_id);
                                    
                    // $is_subscribed = NO;
                    
                    // if($has_subscriptions) {

                    //     $is_subscribed = check_provider_subscribed_category( \Auth::guard('provider')->user()->id, $request->category_id);
                        
                    //     if($is_subscribed) {
                            
                    //         $provider_id = $current_offered_provider->provider_id;
                    //     }

                    // } else {
                        
                        #if cateogory has no paid subscriptions asign provider 
                        $provider_id = $current_offered_provider->provider_id;
                    // }
                }

                // To change the current provider availability and next provider status ,push notification changes
                Helper::assign_next_provider($request->id,$provider_id);

            } else {
                Log::info("Provider Waiting State");
            }        
        }

        Log::info('ASSIGN PROVIDER CRON END');
    }

    // If the scheduled requested time is exceeds the current time means change the status as cancel
    
    // and send notifications to admin , provider and cancel 


    /** 
     * @method scheduled_request_time_exceed()
     *
     * @uses If the scheduled requested time is exceeds the current time means change the status as cancel
     *
     * // and send notifications to admin , provider and cancel 
     *
     * @created Vidhya R
     *
     * @updated Vidhya R
     *
     * @param 
     *
     * @return Boolean
     */

    public function cron_later_request_time_exceed_cancel() {

        Log::info("Scheduled Request Time exceeds function");

        /*
        |--------------------------------------------------------------------------
        | Algorithm for later requests 
        |--------------------------------------------------------------------------
        |
        | This cron job is used to cancel the requests automatically.
        |
        | Admin will set some time limit for later request start from provider. 
        |
        | If the provider not started the request on time, it will get cancel after admin time limit
        |
        */

        try {

            DB::beginTransaction();

            $schedule_exceed_limit_time = Setting::get('later_request_start_time_limit');

            $current_date = date('Y-m-d H:i:s');

            $check_request_date = strtotime('+'.$schedule_exceed_limit_time.' minutes', strtotime($current_date));

            $list_provider_status = [PROVIDER_STARTED,PROVIDER_ARRIVED,PROVIDER_SERVICE_STARTED,PROVIDER_SERVICE_COMPLETED,PROVIDER_RATED];

            $check_later_requests = Requests::where('job_type' , REQUEST_LATER)->where('status' , REQUEST_ONGOING)
                                        ->whereNotIn('provider_status' , $list_provider_status)
                                        ->where('request_date' , '<' , $check_request_date)
                                        ->get();

            $total_exceeds = 0;

            $r_data = $request_data = [];

            if($check_later_requests) {

                foreach ($check_later_requests as $key => $request_details) {

                    if($request_details = Requests::find($request_details->id)) {

                        $request_details->status = REQUEST_TIME_EXCEED_CANCELLED;

                        $request_details->save();

                        $request_data['request_id'] = $request_details->id;

                        $request_data['user_id'] = $request_details->user_id;

                        $request_data['provider_id'] = $request_details->provider_id;

                        array_push($r_data, $request_data);

                        $total_exceeds = $total_exceeds + 1;
                    }

                }
                
            }

            DB::commit();

            Log::info("total_later_requests".count($check_later_requests));

            Log::info("total_exceeds".$total_exceeds);

            $data['total_later_requests'] = count($check_later_requests);

            $data['total_exceeds'] = $total_exceeds;
            
            $data['r_data'] = $r_data;

            $response_array = ['success' => true , 'data' => $data];

            return response()->json($response_array , 200);

        } catch(Exception $e) {

            DB::rollback();

            $error = $e->getMessage();

            $error_code = $e->getCode();

            Log::info('error'.print_r($error , true));

            $response_array = ['success' => false , 'error' => $error];

            return response()->json($response_array , 200);
        }
    }

    /**
     * delete the drafts
     *
     */

    public function delete_drafts() {

        $draft_delete_day = Setting::get('admin_draft_delete_day' , 7);

        $last_week_date = date('Y-m-d H:i:s', strtotime('-'.$draft_delete_day.' day', time()));

        Log::info('Draft Delete Date :'.$last_week_date);

        $drafts = TempRequests::where('updated_at' , '<' , $last_week_date)->forceDelete();

        Log::info('Delete Status:::'.$drafts);

        $response_array = ['success' =>true];

        return response()->json($response_array);

    }

    public function select_sub_category(Request $request) {
        
        $id = $request->option;

        $subcategories = SubCategory::where('category_id', '=', $id)
                        ->where('status' , 1)
                          ->orderBy('name', 'asc')
                          ->get();

        return response()->json($subcategories);
    
    }

    /**
     *
     *
     */

    public function message_save(Request $request) {

      Log::info("message_save".print_r($request->all() , true));

        $this->validate($request, [
                "request_id" => "required|integer",
                "user_id" => "required|integer",
                "provider_id" => "required|integer",
                "type" => "required|in:up,pu",
                "message" => "required",
            ]);

        $type = 'chat';
        
        $message = $request->message;

        $bid_status = $request_meta_id  = "";

        if($request_details = Requests::find($request->request_id)) {

            if($request_details->status < REQUEST_ONGOING) {
                
                // Get meta details

                if($request_meta_details = RequestsMeta::where('request_id' , $request->request_id)->where('provider_id' , $request->provider_id)->first()) {

                    $request_meta_id = $request_meta_details->id;

                    $bid_status = $request_meta_details->status;
                
                }
            
            }
        
        }

        $chat_data = ['provider_id' => "$request->provider_id" , 'user_id' => "$request->user_id" , 'request_meta_id' => "$request_meta_id" , 'bid_status' =>"$bid_status"];

        if($request->type == 'up') {

            $push_send_status = 1;

            // Get Push Status 

            $check_push_status = ChatMessage::where('provider_id' , $request->provider_id)->where('request_id' , $request->request_id)->where('type' , 'up')->orderBy('updated_at' , 'desc')->first();

            if($check_push_status) {
                $push_send_status = $check_push_status->delivered ? 0 : 1;
            }

            if($push_send_status) {

                $title = tr('new_message_from_user');

                $this->dispatch(new sendPushNotification($request->provider_id,PROVIDER,PUSH_USER_CHAT,$title,$message ,  "" , $request->request_id , "" , $chat_data)); 
            }

            // Log::info('Push Sent to Provider');
        
        }

        if($request->type == 'pu') {

            $push_send_status = 1;

            $check_push_status = ChatMessage::where('user_id' , $request->user_id)->where('provider_id', $request->provider_id)->where('request_id' , $request->request_id)->where('type' , 'pu')->orderBy('updated_at' , 'desc')->first();

            if($check_push_status) {
                $push_send_status = $check_push_status->delivered ? 0 : 1;
            }

            if($push_send_status) {

                $title = tr('new_message_from_provider');

                $this->dispatch( new sendPushNotification($request->user_id, USER,PUSH_PROVIDER_CHAT, $title, $message ,"" , $request->request_id, "" , $chat_data));
            }

            // Log::info('Push Sent to User');
        
        }
        
        return ChatMessage::create($request->all());
    
    }

    /** 
     *
     *
     */

    public function message_update_status(Request $request) {

      Log::info("message_update_status".print_r($request->all() , true));

        // Need to update the user status

        if($request->type == 'pu') {

            ChatMessage::where('user_id' , $request->user_id)->where('provider_id' , $request->provider_id)->where('request_id' , $request->request_id)->where('type' , 'pu')->update(['delivered' => 1]);

        } 

        if($request->type == 'up') {

            ChatMessage::where('user_id' , $request->user_id)->where('provider_id' , $request->provider_id)->where('request_id' , $request->request_id)->where('type' , 'up')->update(['delivered' => 1]);

        }

    }

    /**
     * User to become as Provider
     *
     *
     */

    public function become_a_provider(Request $request) {

        // Check the user logged in

        if(\Auth::check()) {

            $user = User::find(Auth::user()->id);

            // Check the provider record exist

            $check_provider =  $provider = Provider::where('email' , \Auth::user()->email)->first();

            if(!$check_provider) {

                $response = CommonRepo::become_a_provider($user);

                if($response['success']) {
                    $provider = $response['data'];
                }
            }

            if($provider) {

                // Save the current login status 

                $user->login_status = 'provider';

                $provider->login_status = 'provider';

                $user->save();

                $provider->save();

                // Login provider

                Auth::guard('provider')->loginUsingId($provider->id);

                // Logout User

                Auth::logout();

                return redirect(route('provider.dashboard'))->with('flash_success' , tr('become_a_provider_success'));
            } else {
                return back()->with('flash_error' , tr('something_error_with_credential'));
            }

        } else {
            return back()->with('flash_error' , tr('something_error'));
        }

    }

    /**
     * Provider to become as User
     *
     *
     */

    public function become_a_user(Request $request) {

        // Check the user logged in

        if(\Auth::guard('provider')->check()) {

            $provider = Provider::find(Auth::guard('provider')->user()->id);

            // Check the provider record exist

            $check_user =  $user = User::where('email' , \Auth::guard('provider')->user()->email)->first();

            if(!$check_user) {

                // Create A record for provider

                $response = CommonRepo::become_a_provider($user);

                if($response['success']) {
                    $user = $response['data'];
                }
            }

            if($user) {

                // Save Current Login status

                $user->login_status = 'user';

                $provider->login_status = 'user';

                $user->save();

                $provider->save();

                // Login User

                Auth::loginUsingId($user->id);

                // Log out Provider

                Auth::guard('provider')->logout();

                return redirect(route('user.dashboard'))->with('flash_success' , tr('become_a_user_success'));

            } else {
                return back()->with('flash_error' , tr('something_error_with_credential'));
            }

        } else {
            return back()->with('flash_error' , tr('something_error'));
        }

    }


    public function set_session_language($lang) {

      $locale = \Session::put('locale', $lang);

      return back()->with('flash_success' , tr('session_success'));
    }

    public function help(Request $request) {

        $page_data['type'] = $page_data['heading'] = $page_data['content'] = "";

        $page = Page::where('type', 'help')->first();

        if($page) {

            $page_data['type'] = "HELP";

            $page_data['heading'] = $page->heading;

            $page_data ['content'] = $page->description;
        }

        $response_array = array('success' => true , 'page' => $page_data);
        return response()->json($response_array,200);

    }

    public function static_terms(Request $request) {

        $page_data['type'] = $page_data['heading'] = $page_data['content'] = "";

        $page = Page::where('type', 'terms')->first();

        if($page) {

            $page_data['type'] = "Terms";

            $page_data['heading'] = $page->heading;

            $page_data ['content'] = $page->description;
        }

        $response_array = array('success' => true , 'page' => $page_data);
        return response()->json($response_array,200);

    }

    /**
     * @method static_privacy()
     *
     * @uses to get the privacy policy
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param integer id (provider primary ID)
     *
     * @param string verification_code
     *
     * @return JSON RESPONSE
     */

    public function static_privacy(Request $request) {

        $page_data['type'] = $page_data['heading'] = $page_data['content'] = "";

        $page = Page::where('type', 'privacy')->first();

        if($page) {

            $page_data['type'] = "Privacy Policy";

            $page_data['heading'] = $page->heading;

            $page_data ['content'] = $page->description;
        }

        $response_array = array('success' => true , 'page' => $page_data);

        return response()->json($response_array,200);

    }

    /**
     * @method user_email_verify()
     *
     * @uses to verify the user account based on the email
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param integer id (provider primary ID)
     *
     * @param string verification_code
     *
     * @return redirect to view page
     */

    public function user_email_verify(Request $request) {

        // Check the request have user ID

        if($request->id) {

            // Check the user record exists

            if($user_details = User::find($request->id)) {

                // Check the user already verified

                if($user_details->is_verified != USER_EMAIL_VERIFIED) {

                    // Check the verification code and expiry of the code

                    $response = Helper::check_email_verification($request->verification_code , $user_details, $error, USER);

                    if($response) {

                        $user_details->is_verified = true;

                        $user_details->verification_code = null;

                        $user_details->verification_code_expiry = null;

                        $user_details->save();

                        \Auth::loginUsingId($request->id);

                        return redirect(route('user.profile'))->with('flash_success',tr('email_verified_success'));

                    } else {

                        return redirect(route('user.login.form'))->with('flash_error' , $error);
                    }

                } else {

                    \Auth::loginUsingId($request->id);

                    return redirect(route('user.profile'))->with('flash_success',tr('email_already_verified'));
                }

            } else {
                return redirect(route('user.login.form'))->with('flash_error',tr('user_record_not_found'));
            }

        } else {

            return redirect(route('user.login.form'))->with('flash_error',tr('something_missing_email_verification'));
        }
    
    }
 

    /**
     * @method provider_email_verify()
     *
     * @uses to verify the provider account based on the email
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param integer id (provider primary ID)
     *
     * @param string verification_code
     *
     * @return redirect to view page
     */

    public function provider_email_verify(Request $request) {

        // Check the request have provider ID

        if($request->id) {

            // Check the provider record exists

            if($provider_details = Provider::find($request->id)) {

                // Check the user already verified

                if(!$provider_details->is_verified) {

                    // Check the verification code and expiry of the code

                    $response = Helper::check_email_verification($request->verification_code , $provider_details, $error, PROVIDER);

                    if($response) {

                        $provider_details->is_verified = PROVIDER_EMAIL_VERIFIED;

                        $provider_details->verification_code = $provider_details->verification_code_expiry = null;

                        $provider_details->save();

                        \Auth::guard('provider')->loginUsingId($request->id);

                        return redirect(route('provider.dashboard'))->with('flash_success',tr('email_already_verified'));


                    } else {

                        return redirect(route('provider.login.form'))->with('flash_error' , $error);
                    }

                } else {

                    \Log::info('User Already verified');

                    \Auth::guard('provider')->loginUsingId($request->id);

                    return redirect(route('provider.profile'))->with('flash_success',tr('email_already_verified'));
                }

            } else {
                return redirect(route('provider.login.form'))->with('flash_error',tr('user_record_not_found'));
            }

        } else {

            return redirect(route('provider.login.form'))->with('flash_error',tr('something_missing_email_verification'));
        }
    
    }

    /**
     * @method mobile_static_page()
     *
     * @uses Based on type, the content will be displayed here(Static Pages)
     *
     * @created vidhya R
     *
     * @updated vidhya R
     *
     * @param 
     *
     * @return 
     */ 
    public function mobile_static_page(Request $request) {

        $page_details = Page::where('type', $request->type)->first();

        return view('static.mobile-page')->with('page_details', $page_details);

    }

    /**
     * @method configuration_mobile()
     *
     * @uses to get the configurations for base products
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param
     *
     * @return JSON Response
     */

    public function configuration_site(Request $request) {

        try {

            // $type = $request->type == USER ? "users" : "providers";

            $validator = Validator::make($request->all(), [
                
                // 'id' => 'required|exists:'.$type.',id',
                // 'token' => 'required',
                // 'type' => 'required',

            ]);

            if($validator->fails()) {

                $error = implode(',',$validator->messages()->all());

                throw new Exception($error, 101);

            } else {

                $config_data = $data = [];

                $payment_data['is_stripe'] = 1;

                $payment_data['stripe_publishable_key'] = Setting::get('stripe_publishable_key') ?: "";

                $payment_data['stripe_secret_key'] = Setting::get('stripe_secret_key') ?: "";

                $payment_data['stripe_secret_key'] = Setting::get('stripe_secret_key') ?: "";

                // $payment_data['is_paypal'] = 1;

                // $payment_data['PAYPAL_ID'] = envfile('PAYPAL_ID') ?: "";

                // $payment_data['PAYPAL_SECRET'] = envfile('PAYPAL_SECRET') ?: "";

                // $payment_data['PAYPAL_MODE'] = envfile('PAYPAL_MODE') ?: "sandbox";

                $data['payments'] = $payment_data;

                $data['urls']  = [];

                $url_data['base_url'] = envfile("APP_URL") ?: "";

                $url_data['socket_url'] = Setting::get("socket_url") ?: "";

                $data['urls'] = $url_data;

                // $notification_data['FCM_SENDER_ID'] = envfile('FCM_SENDER_ID') ?: "";

                // $notification_data['FCM_SERVER_KEY'] = $notification_data['FCM_API_KEY'] = envfile('FCM_SERVER_KEY') ?: "";

                // $notification_data['FCM_PROTOCOL'] = envfile('FCM_PROTOCOL') ?: "";

                // $data['notification'] = $notification_data;

                $data['site_name'] = Setting::get('site_name');

                $data['site_logo'] = Setting::get('site_logo');

                $data['currency'] = Setting::get('currency');

                $data['is_appstore_upload'] = Setting::get('is_appstore_upload', 0);

                $response_array = ['success' => true , 'data' => $data];

                return response()->json($response_array , 200);

            }

        } catch(Exception $e) {

            $error_message = $e->getMessage();

            $response_array = ['success' => false,'error' => $error_message,'error_code' => 101];

            return response()->json($response_array , 200);

        }
   
    }

    /**
     * @method site_status()
     *
     * @uses to check the site status
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param
     *
     * @return JSON Response
     */

    public function site_status(Request $request) {

        try {

            $table = $request->user_type == USER ? 'users' : 'providers';

            $validator = Validator::make($request->all(), [
                'id' => 'required|exists:'.$table,
                'token' => 'required',

            ]);

            if($validator->fails()) {

                $error = implode(',',$validator->messages()->all());

                throw new Exception($error, 101);

            } else {

                $data['status'] = 1;

                $data['reason'] = "";

                $response_array = ['success' => true , 'data' => $data];

                return response()->json($response_array , 200);

            }

        } catch(Exception $e) {

            $error_message = $e->getMessage();

            $response_array = ['success' => false,'error' => $error_message,'error_code' => 101];

            return response()->json($response_array , 200);

        }
    }

    /**
     * @method site_status()
     *
     * @uses to check the site status
     *
     * @created Vidhya R 
     *
     * @updated Vidhya R
     *
     * @param
     *
     * @return JSON Response
     */

    public function v4_migration_upgrade(Request $request) {

        // Request payments provider id update

        $total_providers = 0;

        Requests::chunk(50, function ($requests) use(&$total_providers) {

            foreach ($requests as $request_details) {

                $request_payment_details = RequestPayment::where('request_id', $request_details->id)->update(['provider_id' => $request_details->provider_id, 'is_paid' => $request_details->is_paid]);

                $total_providers++;
            }
        });

        $total_request_payments = 0;

        RequestPayment::chunk(50, function ($request_payments) use(&$total_request_payments) {

            foreach ($request_payments as $request_payment_details) {

                $request_payment_details->paid_date = $request_payment_details->created_at;

                $request_payment_details->save();

                $total_request_payments++;
            }
        });

        $response_array = ['success' => true, 'total_providers' => $total_providers, 'total_request_payments' => $total_request_payments];

        return response()->json($response_array, 200);

    }


    /**
     * @method check_provider_subscription_expiry()
     *
     * @uses To check the role of logged in user (admin/subadmin) 
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param $request - request details 
     *
     * @return 
     */
    public function check_provider_subscription_expiry_cron() {
        
        Log::info("PROVIDER SUBSCIPTION EXPIRY CHECK CRON STARTED");

        $provider_subscription_payment = ProviderSubscriptionPayment::
                            where('provider_subscription_payments.status', PAID)
                            ->whereDate('provider_subscription_payments.expiry_date', '<', date('Y-m-d H:i:s'))
                            ->where('provider_subscription_payments.is_current_subscription','=', YES)
                            ->update(['is_current_subscription' => 0,'status' => 0]);
        Log::info("PROVIDER SUBSCIPTION EXPIRY CHECK CRON END");
    }
}
