<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;

use Illuminate\Support\Facades\Password;

use Illuminate\Http\Request;

use App\User;

use Setting;

use App\Helpers\Helper;

class PasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after successful change of password.
     *
     * @var string
     */

    protected $redirectTo = '/';

    /**
     * The password reset request view that should be used.
     *
     * @var string
     */

    protected $linkRequestView = 'user.auth.passwords.email';

    /**
     * The password reset view that should be used.
     *
     * @var string
     */

    protected $resetView = 'user.auth.passwords.reset';

    /**
     * Create a new password controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function getSendResetLinkEmailSuccessResponse($response) {

        return redirect()->route('user.login.form')->with('flash_success', trans($response));
    }

   public function sendResetLinkEmail(Request $request)
    {

        $this->validate($request, ['email' => 'required|email']);


        $user_details = User::where('email' , $request->email)->first();

        if($user_details) {

            // Check the user verified and decline status

            if($user_details->status == USER_DECLINED) {
                    
                return back()->with('flash_error' , tr('forgot_password_user_not_approved'));
            }

            if($user_details->is_verified == USER_EMAIL_NOT_VERIFIED) {

                if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON && !in_array($user_details->login_by, ['facebook' , 'google'])) {

                    // Check the verification code expiry

                    Helper::check_email_verification("" , $user_details, $error, USER);
                
                    return back()->with('flash_error' , tr('forgot_password_user_not_verified'));

                }
            }
        }

        // We will send the password reset link to this user. Once we have attempted
        // to send the link, we will examine the response then see the message we
        // need to show to the user. Finally, we'll send out a proper response.

        $broker = $this->getBroker();

        $response = Password::broker($broker)->sendResetLink(
            $this->getSendResetLinkEmailCredentials($request),
            $this->resetEmailBuilder()
        );

        switch ($response) {
            case Password::RESET_LINK_SENT:
                return $this->getSendResetLinkEmailSuccessResponse($response);
            case Password::INVALID_USER:
            default:
                return $this->getSendResetLinkEmailFailureResponse($response);
        }
    }


}
