<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

//Braintree Classes
// use Braintree_Transaction;

// use Braintree_Customer;

// use Braintree_WebhookNotification;

// use Braintree_Subscription;

// use Braintree_CreditCard;

// use Braintree_PaymentMethod;

// use Braintree_ClientToken;

class BackupCodeController extends Controller
{

	public function __construct(Request $request) {

        \Braintree_Configuration::environment(envfile('PAYMENT_ENVIRONMENT'));
        \Braintree_Configuration::merchantId(envfile('PAYMENT_MERCHANTID'));
        \Braintree_Configuration::publicKey(envfile('PAYMENT_PUBLICKEY'));
        \Braintree_Configuration::privateKey(envfile('PAYMENT_PRIVATEKEY'));

        $this->middleware('UserApiVal' , array('except' => ['test' ,'register' , 'login' , 'forgot_password']));

        if($request->id)
            
            $this->loginUser = User::CommonResponse()->find($request->id);

    }

    public function card_add(Request $request) {

        $payment_method_nonce = $request->payment_method_nonce;

        $user = User::find($request->id);

        $payment = Card::where('user_id',$request->id)->where('is_deleted',0)->first();

        $user_name = $user->name ? str_replace(' ', "", $user->name) : "JR";

        try {

            Log::info("CARD ADD START");

            if(!$payment){

                Log::info("No Default Card Added");

                $result = \Braintree_Customer::create(array(
                    'firstName' => $user_name,
                    'lastName' => $user_name,
                    'paymentMethodNonce' => $payment_method_nonce
                 ));
                Log::info('paymentMethodNonce = '.print_r($payment_method_nonce, true));

                if($result->success){

                    Log::info('Payment success'.print_r($result, true));

                    Log::info('New User Card add success');

                    if($result->customer->creditCards){

                        Log::info('credit CARD ADDD');

                       $payment = new Card;
                        $payment->user_id = $request->id;
                        $payment->customer_id = $result->customer->id;
                        $payment->payment_method_nonce = $request->payment_method_nonce;
                        $payment->last_four = (string)$result->customer->creditCards[0]->last4;
                        $payment->is_default=1;
                        $payment->card_type = $result->customer->creditCards[0]->cardType;
                        $payment->card_token = 'na';
                        $payment->save();
                        

                        Log::info("First card");

                        if($user) {
                            
                            // $user->payment_mode = CARD;

                            $user->card_id = $payment->id;
                            $user->save();
                            Log::info('Default card changed');
                        }

                        $response_array = array('success' => true,'message'=>tr('thankyou_for_adding_first_card'));


                    } elseif ($result->customer->paypalAccounts){

                        Log::info('paypalAccounts ADD');

                        //adding paypal
                        $payment = new Card;
                        $payment->user_id = $request->id;
                        $payment->customer_id = $result->customer->id;
                        $payment->payment_method_nonce = $request->payment_method_nonce;
                        $payment->paypal_email = $result->customer->paypalAccounts[0]->email;
                        $payment->card_type = 'na';
                        $payment->card_token = 'na';
                        $payment->save();

                        $response_array = array('success' => true,'message'=>tr('thankyou_adding_paypal_first_account'));
                    
                    } else {

                        Log::info('Something missing in New Payment Mode');

                        $response_array = ['success' => false , 'error' => tr('something_missing')];
                    }

                } else {// $result->success failed
                    
                    Log::info("Braintree Adding Card Error:");

                    $response_array = array('success' => true,'message'=>tr('braintree_adding_card_error').$result->message);

                }


            } else { //if payment exist in payment table

                
                Log::info('if payment exist in payment table');

                $customer_id = $payment->customer_id;

                $result = \Braintree_PaymentMethod::create(array(
                    'customerId' => $customer_id,
                    'paymentMethodNonce' => $payment_method_nonce
                ));


                if($result->success)  {

                    if(preg_match('/Braintree_CreditCard/', $result->paymentMethod)){
                        //credit card

                        $payment = new Card;
                        $payment->user_id = $request->id;
                        $payment->customer_id = $customer_id;
                        $payment->payment_method_nonce = $request->payment_method_nonce;
                        $payment->last_four = (string)$result->paymentMethod->last4;
                        $payment->card_type = $result->paymentMethod->cardType;
                        $payment->card_token = 'na';
                        $payment->save();

                        Log::info("Second card");

                        $response_array = array('success' => true,'message'=>tr('thankyou_for_adding_card'));


                    } elseif (preg_match('/Braintree_PayPalAccount/', $result->paymentMethod)
                        )
                    {
                        //paypal
                        $payment = new Card;
                        $payment->user_id = $request->id;
                        $payment->customer_id = $customer_id;
                        $payment->payment_method_nonce = $request->payment_method_nonce;
                        $payment->paypal_email = $result->paymentMethod->email;
                        $payment->card_type = 'na';
                        $payment->card_token = 'na';
                        $payment->save();
                        $response_array = array('success' => true,'message'=>tr('thankyou_adding_paypal_account'));
                    } else {
                        
                        Log::info('Something missing in Old Payment Mode');

                        $response_array = ['success' => false , 'error' => tr('something_missing')];
                    }
                
                } else {
                    
                    Log::info('Braintree Adding Card Error:');

                    $response_array = array('success' => true,'message'=>tr('braintree_adding_card_error').$result->message);
                }
            }

        } catch(Braintree_Exception_Authorization $e) {
            Log::error('Error = '.$e->getMessage());
            $response_array = array('success' => true,'message'=>tr('something_went_wrong'));
        }

        $response = response()->json($response_array, 200);
        return $response;
    
    }

    public function getBraintreeToken(Request $request) {

        $clientToken = \Braintree_ClientToken::generate();

        $response_array = ['success' => true,'client_token' => $clientToken];

        $response = response()->json($response_array, 200);

        return $response;

    }

    public function email_settings_process(Request $request) {

        $email_settings = ['MAIL_DRIVER' , 'MAIL_HOST' , 'MAIL_PORT' , 'MAIL_USERNAME' , 'MAIL_PASSWORD' , 'MAIL_ENCRYPTION'];

        foreach ($email_settings as $key => $data) {

            if($request->has($data)) {
                \Enveditor::set($data,$request->$data);
            }
        }

        $result = \Enveditor::all();

        return redirect(route('clear-cache'))->with('result' , $result)->with('flash_success' , tr('email_settings_success'));


    }
}
