<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

// use App\Http\Requests;

use App\Helpers\Helper;

use App\SubCategory;

use App\Provider;

use App\ProviderService;

use App\Requests;

use App\RequestsMeta;

use App\User;

use App\Document;

use App\RequestPayment;

use App\ProviderDocument;

use Auth;

use App\ProviderNotification;

use Log;

use Session;

use Exception;

use App\ProviderSubscription;

use App\ProviderSubscriptionPayment;

use App\Category;

class ProviderController extends Controller {
    
	protected $providerApi;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(ProviderApiController $API) {
        
        $this->providerApi = $API;
        
        $this->middleware('provider');
    }

    /**
     * Show the provider dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request) {

        // Check provider had completed the registeration process 

        $registeration_step = Auth::guard('provider')->user()->step;

        $job_active = "new-requests";

        if($registeration_step != PROVIDER_STEP_COMPLETE) {

            if($registeration_step == PROVIDER_STEP_INITIAL || $registeration_step == 0) {
                $page = "provider.account.agree";
            } elseif ($registeration_step == PROVIDER_STEP_AGREE) {
                #return to services update section
                $page = "provider.account.services";                
            } else {
                # return to billing section
                $page = "provider.account.profile";
            }

            return view($page);

        } else {

            $new_requests = $bidded_requests = $direct_requests = $confirmed_requests = $ongoing_requests = [];


            if(\Auth::guard('provider')->user()->is_approved == PROVIDER_APPROVED) {

                $request->request->add([ 
                    'id' => \Auth::guard('provider')->user()->id,
                    'token' => \Auth::guard('provider')->user()->token,
                    'device_token' => \Auth::guard('provider')->user()->device_token,
                    'is_web'=> DEVICE_WEB,
                    'skip'=>0
                ]);

                if(!$request->dashboard) {

                    // Check any ongoing requests 

                    $ongoing_requests = $this->providerApi->request_status_check($request)->getData();

                    // If any ongoing requests means redirect to the ongoing page

                    if($ongoing_requests->success) {

                        if($ongoing_requests->data) {

                            $request_details = Requests::find($ongoing_requests->data->request_id);

                            return redirect()->route('provider.requests.view' , $request_details->unique_id);
                        }
                    
                    } 

                }

                $new_response = $this->providerApi->available_requests($request)->getData();

                \Session::set('total_request_cnt', count($new_response));

                if($new_response->success) 
                    $new_requests = $new_response->data;

                $bidded_response = $this->providerApi->bidded_requests($request)->getData();

                if($bidded_response->success) 
                    $bidded_requests = $bidded_response->data;

                $confirmed_response = $this->providerApi->confirmed_requests($request)->getData();

                if($confirmed_response->success) 
                    $confirmed_requests = $confirmed_response->data;

                $direct_response = $this->providerApi->direct_requests($request)->getData();

                if($direct_response->success) 
                    $direct_requests = $direct_response->data;

                $ongoing_response = $this->providerApi->ongoing_requests($request)->getData();

                if($ongoing_response->success) 
                    $ongoing_requests = $ongoing_response->data;

                $job_active = $request->active ? $request->active : 'new-requests';

                if(new_job_notifications() > 0 && $job_active == 'new-requests') {

                    $notification = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)->where('status', DEFAULT_FALSE)->where('job_status', DEFAULT_TRUE)->get();

                    foreach ($notification as $key => $notify) {

                       $notify->status = DEFAULT_TRUE;

                       $notify->save();

                    }

                }

                if (direct_job_notifications() > 0 && $job_active == 'direct-requests') {

                    $model = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)->where('job_status',2)->where('status', DEFAULT_FALSE)->get();

                    foreach ($model as $key => $value) {

                        $value->status = DEFAULT_TRUE;
                        $value->save();

                    }

                }
                if (bidded_job_notifications() > 0 && $job_active == 'bidded-requests') {

                    $model = ProviderNotification::where('provider_id', Auth::guard('provider')->user()->id)->where('job_status',3)->where('status', DEFAULT_FALSE)->get();

                    foreach ($model as $key => $value) {

                        $value->status = DEFAULT_TRUE;
                        $value->save();

                    }

                }

            }


            return view('provider.jobs.index')->with('new_requests' , $new_requests)
                    ->with('confirmed_requests' , $confirmed_requests)
                    ->with('bidded_requests' , $bidded_requests)
                    ->with('direct_requests' , $direct_requests)
                    ->with('ongoing_requests' , $ongoing_requests)
                    ->with('job_active', $job_active)
                    ->with('header_page' , "provider_dashboard");
        
        }
        
    }

    /**
     * Register Flow - Agree the terms and conditions
     *
     */

    public function register_agree(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->register_agree($request)->getData();

        if($response->success) {
            return redirect()->route('provider.dashboard')->with('flash_success', $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }
    
    }

    /**
     * Service view page
     *
     */

    public function services(Request $request) {

        // This variable used to identify whether update form or register flow form in view

        $register_flow = 0;

        return view('provider.account.services')->with('register_flow' , $register_flow);
    }

    /**
     * Provider update the services
     *
     */

    public function services_save(Request $request) {
    
        try {

            // Get All the sub categories list
            $sub_categories = SubCategory::where('status' , APPROVED)->get();
            
            if($sub_categories) {

                foreach ($sub_categories as $key => $sub_category) {

                    // if($request->input('sub_category_id_'.$sub_category->id) == $sub_category->id) {

                        $provider_service = new ProviderService;

                        // Check record already available

                        $check_provider_service = ProviderService::where('provider_id' ,Auth::guard('provider')->user()->id)->where('sub_category_id' , $sub_category->id)->first();

                        if($check_provider_service) {
                            $provider_service = $check_provider_service;
                        }

                        $provider_service->provider_id = Auth::guard('provider')->user()->id;
                        $provider_service->category_id = $sub_category->category_id;
                       
                        $provider_service->sub_category_id = $sub_category->id;

                        $price_hour = $sub_category->id;

                        // Check the provider set price for that category
                        $provider_service->price_per_hour = $request->$price_hour ?: 0;
                       
                        $provider_service->save();

                        $sub_category_id = 'sub_category_id_'.$sub_category->id;

                        // Check the provider selected the category

                        $provider_service->status = ($request->$sub_category_id == $sub_category->id && $request->$price_hour) ? APPROVED : DECLINED;

                        $provider_service->save();

                    // }

                }

                // If provider don't selected any services means keep the provider on that page

                $provider_services = ProviderService::where('provider_id' ,Auth::guard('provider')->user()->id)->where('status' , APPROVED)->count();

                if($request->register_flow && $provider_services) {

                    $provider =Provider::find(Auth::guard('provider')->user()->id);
                    $provider->step = PROVIDER_STEP_COMPLETE;
                    $provider->status = true;
                    $provider->save();

                } 

                if(!$provider_services) {

                    throw new Exception(tr('service_atleast_a_service'), 101);  
                }
                
                return redirect()->route('provider.dashboard')->with('flash_success', tr('action_success'));
            }

            throw new Exception(tr('no_service_avalable'), 101);
            
        } catch (Exception $e) {
                      
            $message = $e->getMessage();

            $code = $e->getCode();

            return redirect()->back()->with('flash_error', $message);
        }
    } 

    /**
     * Location 
     *
     */

    public function location(Request $request) {

        return view('provider.account.location');
    }

    /**
     * change State.
     *
     * @return \Illuminate\Http\Response
     */
    public function change_state(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->available_update($request)->getData();

        return response()->json($response);
    }

    /**
     * Popup incoming request.
     *
     * @return \Illuminate\Http\Response
    */
    public function detect_request(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->request_status_check($request)->getData();

        return response()->json($response);
    }

    /**
     * Location Update Post 
     *
     */

    public function location_save(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->location_update($request)->getData();

        if($response->success) {
            return back()->with('flash_success', $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }

        return view('provider.location');
    }

    /**
     * Show the profile list.
     *
     * @return \Illuminate\Http\Response
     */
    public function profile(Request $request) {

        $model = Provider::find(Auth::guard('provider')->user()->id);

        $amount_details = get_provider_amount(Auth::guard('provider')->user()->id);

        $redeem_details = $model ? $model->providerPayment : new ProviderPayment;
        
        $galleries = $model->providerGalleries;

        $profile_active = $request->profile_active ? $request->profile_active : "profile"; 

        Log::info("profile_active".$profile_active);

        return view('provider.account.profile')->with('page' , 'profile')
                    ->with('model', $model)
                    ->with('amount_details', $amount_details)
                    ->with('redeem_details', $redeem_details)
                    ->with('header_page' , "provider_account")
                    ->with('galleries' , $galleries)
                    ->with('profile_active' , $profile_active);
    }    

    /**
     * @method gallery()
     *
     * @uses to display provider gallery
     *
     * @created Anjana H
     * 
     * @edited Anjana H
     *
     * @param 
     *
     * @return 
     */
    public function gallery(Request $request) {

        $model = Provider::find(Auth::guard('provider')->user()->id);

        $galleries = $model->providerGalleries;

        return view('provider.account.gallery')
                    ->with('page' , 'profile')
                    ->with('model', $model)
                    ->with('header_page' , "provider-gallery")
                    ->with('galleries' , $galleries);   
    }

    /**
     * Show the profile list.
     *
     * @return \Illuminate\Http\Response
     */
    public function update_profile()
    {
        return view('user.settings.edit-profile')->with('page' , 'profile')
                    ->with('subPage' , 'user-update-profile');
    }

    /**
     *
     * @method profile_save()
     *
     * @uses Save any changes to the users profile.
     *
     * @created vidhya R
     *
     * @edited vidhya R
     *
     * @param
     *
     * @return \Illuminate\Http\Response
     */
    public function profile_save(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->update_profile($request)->getData();

        if($response->success) {

            return back()->with('flash_success', tr('profile_updated'));

        } else {

            $message = $response->error;

            return back()->with('flash_error', $message);
        }
        
    }

    /**
     * @method profile_change_password()
     *
     * @uses change the password of the provider and logout
     *
     * @created Vidhya R 
     *
     * @edited Vidhya R
     *
     * @param form data
     *
     * @return \Illuminate\Http\Response
     */
    public function profile_change_password(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->change_password($request)->getData();

        if($response->success) {

            Auth::guard('provider')->logout();

            return redirect()->route('provider.login.form')->with('flash_success' , tr('password_success'));

        } else {    
                
            return redirect()->route('provider.profile' , ['profile_active' => 'change_password'])->with('flash_error', $response->error ? $response->error: "");

        }
    }


    /**
     * @method delete_account()
     *
     * @uses to delete the logged in provider
     *
     * @created Vidhya R
     * 
     * @edited Vidhya R
     *
     * @param 
     *
     * @return 
     */

    public function delete_account(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->delete_account($request)->getData();

        if($response->success) {

            return redirect()->route('provider.login.form')->with('flash_success' , tr('provider_account_delete_success'));

        } else {

            return redirect()->route('provider.profile' , ['profile_active' => 'delete_account'])->with('flash_error', $response->error);
        }

        return redirect()->route('provider.profile' , ['profile_active' => 'delete_account'])->with('flash_error', Helper::error_message(146));

    }

    /**
     * @method gallery() NOT USING NOW
     *
     * @uses to get gallery details 
     *
     * @created Vidhya R
     * 
     * @edited Vidhya R
     *
     * @param 
     *
     * @return view page
     */

    public function galleries_index(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->galleries_index($request)->getData();

        if($response->success) {

            $galleries = $response->data;

            $model = Provider::find(Auth::guard('provider')->user()->id);

            $amount_details = get_provider_amount(Auth::guard('provider')->user()->id);

            return view('provider.account.gallery')->with('page' , 'profile')
                    ->with('model', $model)
                    ->with('amount_details', $amount_details)
                    ->with('header_page' , "gallery")
                    ->with('profile_active' , 'gallery');
        } else {

            return back()->with('flash_error', $response->error);
        }

        return back()->with('flash_error', Helper::error_message(146));

    }

    /**
     * @method galleries_save()
     *
     * @uses to save the gallery images
     *
     * @created Vidhya R
     * 
     * @edited Vidhya R
     *
     * @param 
     *
     * @return view page
     */

    public function galleries_save(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->galleries_save($request)->getData();

        if($response->success) {

            $message = $response->message;

            return redirect()->route('provider.profile' , ['profile_active' => 'provider-gallery'])->with('flash_success' , $message);

            
        } else {

            return redirect()->route('provider.profile' , ['profile_active' => 'provider-gallery'])->with('flash_error', $response->error);
        }

    }

    /**
     * @method galleries_delete()
     *
     * @uses to save the gallery images
     *
     * @created Vidhya R
     * 
     * @edited Vidhya R
     *
     * @param 
     *
     * @return view page
     */

    public function galleries_delete(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->galleries_delete($request)->getData();

        if($response->success) {

            $message = $response->message;

            return redirect()->route('provider.profile' , ['profile_active' => 'provider-gallery'])->with('flash_success' , $message);

            
        } else {

            return redirect()->route('provider.profile' , ['profile_active' => 'provider-gallery'])->with('flash_error', $response->error);
        }

    }

    /**
     * History of the provider jobs
     *
    */

    public function history(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);
       
        if($request->cancelled_jobs == YES) {
            $request->request->add([ 
                'cancelled_jobs' => $request->cancelled_jobs
            ]);
        }
        
        $response = $this->providerApi->history($request)->getData();

        if($response->success) {
            return view('provider.jobs.history')->with('requests' , $response->data)->with('header_page' , "provider_history");
        } else {

            return back()->with('flash_error', $response->error);
        }
    }

    /**
     * @method requests_view()
     *
     * @uses to get selected request details
     *
     * @created Vidhya R
     *
     * @edited Vidhya R
     *
     * @param integer id, string token
     *
     * @return redirect view page or JSON Response
     */ 

    public function requests_view($request_unique_id) {

        $request_details = Requests::where('unique_id' ,$request_unique_id)->first();

        $requests_meta =  $messages = [];

        if($request_details) {

            $request_details->price_type = price_type($request_details->price_type);

            $request_payment_details = $request_details->payments ? $request_details->payments : new RequestPayment;

            if($request_details->provider_id == 0 || $request_details->provider_id == Auth::guard('provider')->user()->id) {

                // Check whether the user sent any messages - To show the chat option to provider

                $messages = check_provider_chat($request_details->user_id , \Auth::guard('provider')->user()->id , $request_details->id);

                if(in_array($request_details->status, [REQUEST_CANCELLED,REQUEST_NO_PROVIDER_AVAILABLE, REQUEST_TIME_EXCEED_CANCELLED])) {

                    return redirect()->route('provider.dashboard')->with('flash_error' , tr('request_cancel_timeout'));
                }

                $requests_meta = RequestsMeta::where('provider_id' , Auth::guard('provider')->user()->id)->where('request_id' , $request_details->id)->first();

            } else {
               
                return redirect()->route('provider.dashboard')->with('flash_error', tr('provider_doesnt_have_access'));
            }

        } else {

            return redirect()->route('provider.dashboard')->with('flash_error', tr('something_error'));
        }

        return view('provider.jobs.view')
                    ->with('request_details' , $request_details)
                    ->with('requests_meta' , $requests_meta)
                    ->with('request_payment_details' , $request_payment_details)
                    ->with('messages' , $messages);
    }

    /**
     * User profile
     *
     *
     */

    public function user_profile($user_id = "" , $request_id = "") {

        $user = [];

        if($user_id) {

            $user = User::where('unique_id' , $user_id)->first();
        }

        if($user) {

            $requests_meta = $request_details = [];

            if($request_id) {

                $request_details = Requests::where('unique_id' , $request_id)->first();

                $requests_meta = RequestsMeta::where('provider_id' , Auth::guard('provider')->user()->id)->where('request_id' , $request_id)->first();

            }

            return view('provider.jobs.user-profile')->with('user' , $user)->with('requests_meta' , $requests_meta)->with('request_details' , $request_details);
        
        } else {
            return back()->with('flash_error' , tr('something_error'));
        }
    }

     /**
     * Popup incoming request.
     *
     * @return \Illuminate\Http\Response
     */
    public function incoming_request(Request $request)
    {
        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $ApiResponse = $this->providerApi->incoming_request($request)->getData();

        // dd($ApiResponse);

        return response()->json($ApiResponse);
    }

    /**
     * Accept request.
     *
     * @return \Illuminate\Http\Response
     */
    public function accept_request(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->request_accept($request)->getData();

        if($response->success == true) {

            $request_details = Requests::find($request->request_id);
            
            return redirect()->route('provider.requests.view' , $request_details->unique_id)
            ->with('success', tr('request_accept')); 

        } elseif($response->success == false) {
            
            return back()->with('error', tr('something_error'));
        }

    }

    /**
     * Decline request.
     *
     * @return \Illuminate\Http\Response
     */
    public function decline_request(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->request_reject($request)->getData();

        if($response->success == true) {            
            return back()->with('success', tr('request_decline')); 

        } elseif($response->success == false) {
            return back()->with('error', tr('something_error'));
        }
    }

    /**
     * Send bid to the particular reqeust
     *
     */

    public function send_bid_request(Request $request) {

         $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->send_bid_request($request)->getData();

        if($response->success) {
            return back()->with('flash_success' , $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }
    }

    /**
     * Confirm Assigned project
     *
     */

    public function confirm_request(Request $request) {

         $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->confirm_request($request)->getData();

        if($response->success) {
            return back()->with('flash_success' , $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }
    }

    /**
     * Cancel Assigned project
     *
     */

    public function request_cancel(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->request_cancel($request)->getData();

        if($response->success) {
            return back()->with('flash_success' , $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }
    }
    /**
     * Cancel Assigned project
     *
     */

    public function check_provider_started(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->check_provider_started($request)->getData();

        if($response->success) {
            return back()->with('flash_success' , $response->message);
        } else {
            return back()->with('flash_error', $response->error);
        }
    }

     /**
     * switch provider action.
     *
     * @return \Illuminate\Http\Response
     */
    public function switch_state(Request $request) {

        $response = '';

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        switch ($request->type) {

            case "STARTED":
                $response = $this->providerApi->provider_started($request)->getData();
                break;
            case "ARRIVED":
                $response = $this->providerApi->provider_arrived($request)->getData();
                break;
            case "SERVICE_STARTED":
                $response = $this->providerApi->request_started($request)->getData();
                break;
            case "SERVICE_COMPLETED":
                $response = $this->providerApi->request_completed($request)->getData();
                break;
            default:
                return back()->with('error',tr('something_error'));
        }

        if($response->success) {
            return back()->with('flash_success', $response->message);
        } 
        
        return back()->with('flash_error', $response->error);
    }

    /**
     *
     * Paid Confirm
     *
     *
     */

    public function request_payment_confirm(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->request_payment_confirm($request)->getData();

        if($response->success) {
            return back()->with('flash_success' , $response->message);
        } 

        return back()->with('flash_error', $response->error);        
    }

    /**
     *
     * Paid Confirm
     *
     *
     */

    public function request_rating(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->request_rating($request)->getData();

        if($response->success) {
            
            return back()->with('flash_success' , $response->message);

        }
        
        return back()->with('flash_error', $response->error);
        
    }
        
    /**
     * Get request status
     *
     */

    public function refresh_single_request(Request $request) {

        $requests = Requests::find($request->request_id);

        $requests_meta = RequestsMeta::where('provider_id' , \Auth::guard('provider')->user()->id)->where('request_id' , $request->request_id)->first();

        $requests_meta = $requests_meta ? $requests_meta : "";

        $response_array = ['success' => true , 'requests' => $requests , 'requests_meta' => $requests_meta];

        return response()->json($response_array,200);
        
    }

    /**
     * Provider and user chat page 
     *
     *
     */

    public function chat($request_unique_id , $user_unique_id) {

        $request_details = Requests::where('unique_id' , $request_unique_id)->first();

        $user = User::where('unique_id' ,$user_unique_id)->first();

        $messages = [];

        if($request_details && $user) {

            // Check whether the user sent any messages - To show the chat option to provider

            $messages = check_provider_chat($request_details->user_id , \Auth::guard('provider')->user()->id , $request_details->id);

            if($messages) {

                return view('provider.jobs.chat')
                        ->with('request_details' , $request_details)
                        ->with('user' , $user)
                        ->with('messages' , $messages);
            } else {

                return back()->with('flash_error', tr('provider_chat_initiate_error'));
            }

        }
        
        return back()->with('flash_error' , tr('something_error'));
        
    }


    public function requests_chat_history(Request $request) {
        
        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->requests_chat_history($request)->getData();

        return response()->json($response->data);
    }

    /**
     *
     * @method documents_upload()
     *
     * @uses to upload the document
     *
     * @created vidhya R
     *
     * @updated vidhya R
     *
     * @param 
     *
     * @return 
     */

    public function documents_upload(Request $request) {

        $get_documents = get_document_types();

        foreach ($get_documents as $document) {

            $document_id = $document->id;

            if($request->hasFile($document_id)) {

                $provider_document =  new ProviderDocument;

                $check_document = get_provider_document($document->id , \Auth::guard('provider')->user()->id);

                if($check_document) {
                    $provider_document = $check_document;
                }

                $provider_document->provider_id = \Auth::guard('provider')->user()->id;
                
                $provider_document->document_id = $document->id;

                $document_url = 'document_url_'.$document->id;

                if($request->has($document_url))

                    Helper::delete_avatar('uploads/documents' ,$request->$document_url);

                $provider_document->document_url = Helper::upload_avatar('uploads/documents' , $request->file($document_id));
                
                $provider_document->save();
            }
        }

        return redirect()->route('provider.profile', ['profile_active' => 'document'])->with('flash_success', tr('document_updated'));
    
    }

    /**
     *
     * @method documents_delete()
     *
     * @uses to delete the document uploaded by provider
     *
     * @created vidhya R
     *
     * @updated vidhya R
     *
     * @param 
     *
     * @return 
     */

    public function documents_delete($document_id) {

        $provider_document = ProviderDocument::find($document_id);

        if($provider_document) {
            Helper::delete_avatar('uploads/documents' ,$provider_document->document_url);
        }

        if($provider_document->delete()) {

            return redirect()->route('provider.profile' , ['profile_active' => 'document'])->with('flash_success',tr('document_delete'));
        } else{
            return redirect()->route('provider.profile' , ['profile_active' => 'document'])->with('flash_error',tr('something_error'));
        }

    }


    /**
     *
     * @method payment_update()
     *
     * @uses to update payment mail address
     * 
     * @created vidhya R
     *
     * @updated vidhya R
     *
     * @param 
     *
     * @return json response
     */

    public function payment_update(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
        ]);

        $response = $this->providerApi->payment_update($request)->getData();

        if($response->success) {
            return redirect()->route('provider.profile' , ['profile_active' => 'billing'])->with('flash_success' , $response->message);
        }

        return redirect()->route('provider.profile' , ['profile_active' => 'billing'])->with('flash_error', $response->error);
        
    }

    public function ajax_new_requests(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'is_web'=>DEVICE_WEB,
            'skip'=>$request->skip,
            's_k'=>$request->search_key,
        ]);

        $new_response = $this->providerApi->available_requests($request)->getData();
       
        if($new_response->success) 
            $new_requests = $new_response->data;

        $view  = \View::make('provider.jobs.ajax_request_responses.new_requests')->with('new_requests', $new_requests)->render();

        return response()->json(['view'=>$view, 'length'=>count($new_requests)]);

    }

    public function ajax_direct_requests(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'is_web'=>DEVICE_WEB,
            'skip'=>$request->skip,
            's_k'=>$request->search_key,
        ]);

        $direct_response = $this->providerApi->direct_requests($request)->getData();

        if($direct_response->success) 
            $direct_requests = $direct_response->data;

        $view  = \View::make('provider.jobs.ajax_request_responses.direct_requests')->with('direct_requests', $direct_requests)->render();

        return response()->json(['view'=>$view, 'length'=>count($direct_requests)]);

    }

    public function ajax_bidded_requests(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'is_web'=>DEVICE_WEB,
            'skip'=>$request->skip,
            's_k'=>$request->search_key,
        ]);

        $bidded_response = $this->providerApi->bidded_requests($request)->getData();

        if($bidded_response->success) 
            $bidded_requests = $bidded_response->data;

        $view  = \View::make('provider.jobs.ajax_request_responses.bidded_requests')->with('bidded_requests', $bidded_requests)->render();

        return response()->json(['view'=>$view, 'length'=>count($bidded_requests)]);

    }


    public function ajax_confirmed_requests(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'is_web'=>DEVICE_WEB,
            'skip'=>$request->skip,
            's_k'=>$request->search_key,
        ]);

        $confirmed_response = $this->providerApi->confirmed_requests($request)->getData();

        if($confirmed_response->success) 
            $confirmed_requests = $confirmed_response->data;

        $view  = \View::make('provider.jobs.ajax_request_responses.confirmed_requests')->with('confirmed_requests', $confirmed_requests)->render();

        return response()->json(['view'=>$view, 'length'=>count($confirmed_requests)]);

    } 

    
    public function ajax_ongoing_requests(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'is_web'=>DEVICE_WEB,
            'skip'=>$request->skip,
            's_k'=>$request->search_key,
        ]);

        $ongoing_response = $this->providerApi->ongoing_requests($request)->getData();

        if($ongoing_response->success) 
            $ongoing_requests = $ongoing_response->data;

        $view  = \View::make('provider.jobs.ajax_request_responses.ongoing_requests')->with('ongoing_requests', $ongoing_requests)->render();

        return response()->json(['view'=>$view, 'length'=>count($ongoing_requests)]);

    }   


    public function see_all_notifications() {

        $model = ProviderNotification::select('provider_notifications.id as notify_id', 
            'provider_notifications.notification as notification', 
            'users.picture as picture',
            'users.name as name',
            'provider_notifications.user_id as user_id',
            'provider_notifications.request_id as request_id',
            'requests.unique_id as unique_id',
            'provider_notifications.created_at as created_at')
        ->where('provider_notifications.provider_id', Auth::guard('provider')->user()->id)
        ->leftJoin('users', 'users.id', '=', 'provider_notifications.user_id')
        ->leftJoin('requests', 'requests.id', '=', 'provider_notifications.request_id')
        ->orderBy('created_at', 'desc')->paginate(16);

        return view('provider.jobs.notification')->with('model', $model);

    }

    /**
     * 
     * @method send_redeem_request()
     *
     * @uses Send Request to admin
     *
     * @created vidhya R
     *
     * @edited vidhya R
     *
     * @param
     *
     * @return view page
     *
     */

    public function send_redeem_request(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token
        ]);

        $response = $this->providerApi->send_redeem_request($request)->getData();

        if($response->success) {

            return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_success', tr('send_redeem_request_success'));

        } else {

            return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_error', $response->error);
        }

        return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_error', Helper::error_message(404));

    }

    /**
     * 
     * @method redeem_request_cancel()
     *
     * @uses cancel the redeem request sent to admin
     *
     * @created vidhya R
     *
     * @edited vidhya R
     *
     * @param
     *
     * @return view page
     *
     */

    public function redeem_request_cancel($id , Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
            'device_token' => \Auth::guard('provider')->user()->device_token,
            'redeem_request_id' => $id,
        ]);

        $response = $this->providerApi->redeem_request_cancel($request)->getData();

        if($response->success) {

            return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_success', tr('send_redeem_request_success'));

        } else {

            return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_error', $response->error);
        }

        return redirect()->route('provider.profile' , ['profile_active' => 'redeems'])->with('flash_error', tr('something_error'));

    }

    /**
     * @method subscriptions_history()
     *
     * @uses To list subscriptions details
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param Integer (request) $provider_id , (request) provider details
     *
     * @return success/error message
     *
     */
    public function subscriptions_history(Request $request) {

        try {
          
            $request->request->add([ 
                'skip' => $request->skip ?: 0,
                'id' => \Auth::guard('provider')->user()->id,
            ]); 

            $subscriptions_history_response = $this->providerApi->subscriptions_history($request)->getData();

            if ($subscriptions_history_response->success) {

                $provider_subscription_payments = $subscriptions_history_response->data;

                if($request->ajax()) {

                    $history_view = view('provider.subscriptions._history')->with('provider_subscription_payments', $provider_subscription_payments)->render();

                    return response()->json(['success' => true, 'html_view'=> $history_view, 'total' => count($provider_subscription_payments)]);

                }

                $profile_active = $request->profile_active ? $request->profile_active : "provider-subscriptions";
       
                Log::info("profile_active".$profile_active);

                return view('provider.subscriptions.history')
                        ->with('provider_subscription_payments', $provider_subscription_payments)
                        ->with('profile_active' , $profile_active);                        
            }   
              
            throw new Exception($response->error, $response->error_code);
                          
        } catch (Exception $e) {

            return redirect()->back()->with('flash_error', $e->getMessage());
        }

    }

    /**
     * @method subscriptions_index()
     *
     * @uses To list subscriptions details
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param Integer (request) $provider_id , (request) provider details
     *
     * @return success/error message
     *
     */
    public function subscriptions_index(Request $request) {

        try {

            $provider_id = Auth::guard('provider')->user()->id;

            $request->request->add([
                'id'=>$provider_id,
                'token'=>Auth::guard('provider')->user()->token
            ]);
            
            #get category based subscriptions
            
            $category_details = [];

            if($request->category_id) {
                
                $request->request->add([
                    'category_id'=>$request->category_id,
                ]);

                $category_details = Category::find($request->category_id);

                if(!$category_details) {

                    throw new Exception(tr('category_not_found'), 101);
                }
            }
                        
            $subscriptions_response = $this->providerApi->subscriptions($request)->getData();
            
            $subscriptions_history_response = $this->providerApi->subscriptions_history($request)->getData();
            
            if ($subscriptions_response->success) {

                $provider_subscriptions = $subscriptions_response->data;
                
                $active = 'subscriptions';

                return view('provider.subscriptions.index')
                        ->with('active', $active)
                        ->with('provider_subscriptions', $provider_subscriptions)
                        ->with('category_details', $category_details);
            }   
              
            throw new Exception($response->error, $response->error_code);
                          
        } catch (Exception $e) {

            return redirect()->back()->with('flash_error', $e->getMessage());

        }

    }

    /**
     * @method subscriptions_invoice()
     *
     * @uses To display subscriptions details choosen by provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param Integer (request) $provider_id , (request) provider details
     *
     * @return success/error message
     *
     */
    public function subscriptions_invoice(Request $request) {
        
        $active = 'subscriptions';

        $provider_details = Provider::find( Auth::guard('provider')->user()->id );

        if(!$provider_details ) {

            throw new Exception( tr('provider_not_found'), 101);
        } 

        $provider_subscription_details = ProviderSubscription::where('provider_subscriptions.status', APPROVED)->where('id', $request->provider_subscription_id)->CommonResponse()->first();

        $category_details = Category::find($provider_subscription_details->category_id);
        
        $provider_subscription_details->category_name = tr('category_not_available');

        if($category_details) {

            $provider_subscription_details->category_name = $category_details->name;
        }
        
        return view('provider.subscriptions.invoice')
                ->with('active', $active)
                ->with('provider_details', $provider_details)
                ->with('provider_subscription_details', $provider_subscription_details);
    
    }

    /**
     * @method subscriptions_save()
     *
     * @uses To view save package choosen by provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param Integer (request) $provider_id , (request) provider details
     *
     * @return success/error message
     *
     */
    public function subscriptions_save(Request $request)  {
        
        try {

            $request->request->add([
                'id'=>Auth::guard('provider')->user()->id,
                'token'=>Auth::guard('provider')->user()->token
            ]);

            $response = $this->providerApi->subscriptions_payment_by_stripe($request)->getData();
            
            if ($response->success) { 

                #return to services update section if provider is on initial steps 
                $registeration_step = Auth::guard('provider')->user()->step;
                
                if ($registeration_step != PROVIDER_STEP_COMPLETE) {
                    #return to services update section
                    return redirect()->route('provider.dashboard')->with('message', $response->message);                
                } 

                return redirect()->route('provider.subscriptions.history')->with('message', $response->message);
            }

            if(!$response->success && $response->error_code == 143) {

                return redirect()->route('provider.cards')->with('flash_error', $response->error);
            }

            throw new Exception($response->error, $response->error_code);
                       
        } catch (Exception $e) {

            return redirect()->back()->with('flash_error', $e->getMessage());

        }

    }
 
    /**
     * @method cards_index()
     *
     * @uses To List card details based on logged in provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param 
     *
     * @return success/error message
     *
     */
    public function cards_index(Request $request) {

        $request->request->add([
            'id'=>Auth::guard('provider')->user()->id,
            'token'=>Auth::guard('provider')->user()->token,
            'login_by'=>Auth::guard('provider')->user()->login_by
        ]);

        $profile_active = $request->profile_active ? $request->profile_active : "provider-cards";

        $cards = $this->providerApi->cards_list($request)->getData();
       
        Log::info("profile_active".$profile_active);

        return view('provider.account.cards')
                    ->with('cards', $cards)
                    ->with('profile_active' , $profile_active);
    }

    /**
     * @method cards_add()
     *
     * @uses To add card details of logged in provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param 
     *
     * @return success/error message
     *
     */
    public function cards_add(Request $request) {

        try {
            
            $request->request->add([ 
                'id' => \Auth::guard('provider')->user()->id,
                'token' => \Auth::guard('provider')->user()->token,
                'card_token'=>$request->stripeToken,
                'cvv'=>$request->cvc,
                'month'=>$request->expiry_month,
                'year'=>$request->expiry_year,
            ]);

            $response = $this->providerApi->cards_add($request)->getData();

            if($response->success) {

                #return to registration steps if provider is on registration steps 
                if (Auth::guard('provider')->user()->step != PROVIDER_STEP_COMPLETE) {

                    return redirect()->route('provider.dashboard')->with('message', $response->message);                
                } 

                return back()->with('flash_success', $response->message);
            } 

            throw new Exception($response->error);
                
        } catch (Exception $e) {

            return redirect()->back()->with('flash_error', $e->getMessage());
        }
    
    }

    /**
     * @method cards_default()
     *
     * @uses To set default card based on logged in provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param (request) card id
     *
     * @return success/error message
     *
     */
    public function cards_default(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
        ]);

        $response = $this->providerApi->cards_default($request)->getData();

        if($response->success) {

            return back()->with('flash_success', $response->message);

        }

        return back()->with('flash_error', $response->error);
        
    }

    /**
     * @method cards_delete()
     *
     * @uses To delete card details of logged in provider
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param (request) card id
     *
     * @return success/error message
     *
     */
    public function cards_delete(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
        ]);

        $response = $this->providerApi->cards_delete($request)->getData();

        if($response->success) {

            return back()->with('flash_success', $response->message);

        }
        
        return back()->with('flash_error', $response->error);
            
    }    


    /**
     * @method revenues()
     *
     * @uses To  dispay logged in provider revenue details
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *
     * @param 
     *
     * @return success/error message
     *
     */
    public function revenues(Request $request) {

        $request->request->add([ 
            'id' => \Auth::guard('provider')->user()->id,
            'token' => \Auth::guard('provider')->user()->token,
        ]);

        $revenues = $this->providerApi->revenues($request)->getData();
        
        if($revenues->success) {

            return view('provider.account.revenues')
                    ->with('revenues', $revenues);

        }
       
        return back()->with('flash_error', $revenues->error);
    }

}
