<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Repositories\RequestRepository as RequestRepo;

use App\Jobs\sendPushNotification;

use App\Helpers\Helper;

use App\User;

use App\Provider;

use App\Requests;

use App\RequestMeta;

use App\TempRequests;

use App\Card;

use Validator;

use Setting;

use Log;

class RequestsController extends Controller {

    public function __construct(Request $request) {

        $this->middleware('UserApiVal' , array('except' => []));

    }

    public function request_settings(Request $request) {

        $job_type = ['request_now' => Setting::get('request_now') , 'request_later' => Setting::get('request_later')];
        $request_type = [
                    'request_type_location' => Setting::get('request_type_location') , 
                    'request_type_category' => Setting::get('request_type_category') , 
                    'request_type_direct' => Setting::get('request_type_direct')
                    ];

        $response_array = ['success' => true , 'job_type' => $job_type , 'request_type' => $request_type];

        return response()->json($response_array, 200);

    }

	public function index(Request $request) {

	}

    public function draft_request(Request $request) {

        $response_array = RequestRepo::draft($request);

        return response()->json($response_array, 200);

    }

    /**
     * @method request_now()
     *
     * @uses to create request now job
     *
     * @created Vidhya R
     *
     * @updated Vidhya R 
     *
     * @param object $request Form data
     * 
     * @return Boolean
     *
     */

    public function request_now(Request $request) {

        // Check the temp_request record exists

        if(!$temp_request = TempRequests::where('id' ,$request->temp_request_id)->where('user_id' , $request->id)->first()) {

            $response_array = ['success' => false , 'error' => Helper::error_message(112) , 'error_code' => 112];

            return response()->json($response_array , 200);
        
        }

        // Check the job type is REQUEST_NOW

        if($temp_request->job_type != REQUEST_NOW) {

            $response_array = ['success' => false , 'error' => Helper::error_message(148) , 'error_code' => 148];

            return response()->json($response_array , 200);
        }

        // Check the job type is enabled by admin

        $allow = RequestRepo::check_request_type_settings($temp_request->job_type , $temp_request->request_type);

        if($allow) {

            // For common validation , request_date = current date is adding for request now

            $request->request->add(['request_date' => date('Y-m-d H:i:s')]);

            // Form Details validation

            if(!RequestRepo::basic_validation($request->all(), $errors)) {

                $response_array = ['success' => false , 'error' => $errors , 'error_code' => 101];

            } else {

                // Save the location details of the user

                $user_details = User::find($request->id);

                // Save the user location

                $user_details->latitude = $request->s_latitude;

                $user_details->longitude = $request->s_longitude;

                if($request->has('payment_mode')) {

                    $user_details->payment_mode = $request->payment_mode;
                }

                $user_details->save();

                $temp_request->s_latitude = $request->s_latitude;

                $temp_request->s_longitude = $request->s_longitude;

                $temp_request->s_address = $request->s_address;

                $temp_request->save();

                if(!$user_details->payment_mode) {

                    $uset_details->payment_mode = COD;

                    $user_details->save();

                    Log::info('Payment Mode is not available');

                    // $response_array = ['success' => false , 'error' => Helper::error_message(150) , 'error_code' => 150];

                } else {

                    $allow = DEFAULT_TRUE;

                    // if the payment mode is CARD , check if any default card is available

                    if($user_details->payment_mode == CARD) {

                        $user_card_details = Card::find($user_details->card_id);

                        if(count($user_card_details) == 0) {

                            $allow = DEFAULT_FALSE;
                        }

                    }

                    if($allow) {

                        // Check any payment pending requests , return value is boolean

                        $payment_pending = RequestRepo::check_payment_pending($request->id);

                        if(!$payment_pending) {

                            $response_array = ['success' => false , 'error' => Helper::error_message(151) , 'error_code' => 151];

                            return response()->json($response_array , 200);
                        }

                        $response_array = [];

                        // Check the any ongoing requests or assigned requests on user requested date

                        // $data = RequestRepo::request_date_validation($request);

                        $check_status = [REQUEST_NONE,REQUEST_NO_PROVIDER_AVAILABLE,REQUEST_TIME_EXCEED_CANCELLED,REQUEST_CANCELLED,REQUEST_COMPLETED];

                        $check_requests = Requests::where('user_id' , $request->id)->where('job_type' , REQUEST_NOW)->whereNotIn('status' , $check_status)->count();

                        if($check_requests == 0) {

                            // Get the provider details 

                            $response_array = RequestRepo::location_providers_save($request , $temp_request , REQUEST_NOW); 

                            if($response_array['success']) {
                                
                                $temp_request->forceDelete();
                            }
                        
                        } else {
                            $response_array = ['success' => false , 'error' => Helper::error_message(128) , 'error_code' => 128];
                        }
                    
                    } else {
                        $response_array = ['success' => false , 'error' => Helper::error_message(146) , 'error_code' => 146];
                    }
               
                }
            } 

        } else {

            Log::info('Request Type or Job Type is disabled by admin');

            $response_array = ['success' => false , 'error' => Helper::error_message(115) , 'error_code' => 115];
        }

        return response()->json($response_array , 200);
    
    }

    /**
     * Used to create request later job
     * 
     * @param :  object $request Form data
     * 
     * @return : Boolean
     *
     */

    public function request_later(Request $request) {

        Log::info("request_later".print_r($request->all() , true));

        if(!$temp_request = TempRequests::where('id' ,$request->temp_request_id)->where('user_id' , $request->id)->first()) {

            $response_array = ['success' => false , 'error' => Helper::error_message(112) , 'error_code' => 112];

            return response()->json($response_array , 200);
        
        }

        // Check the job type is REQUEST_LATER

        if($temp_request->job_type != REQUEST_LATER) {

            $response_array = ['success' => false , 'error' => Helper::error_message(149) , 'error_code' => 149];

            return response()->json($response_array , 200);
        }

        // Check the job type and request types are enabled by admin

        $allow = RequestRepo::check_request_type_settings($temp_request->job_type , $temp_request->request_type);

        if($allow) {

            if(!RequestRepo::basic_validation($request->all(), $errors)) {

                $response_array = ['success' => false , 'error' => $errors , 'error_code' => 101];

            } else {

                $user = User::find($request->id);

                if($request->has('payment_mode')) {
                    
                    $user->payment_mode = $request->payment_mode;
                }

                $user->save();

                if(!$user->payment_mode) {

                    $user->payment_mode = COD;

                    $user->save();
                    
                    // Log::info('Payment Mode is not available');
                    
                    $response_array = array('success' => false , 'error' => Helper::error_message(134) , 'error_code' => 134);

                } else {

                    $allow = DEFAULT_FALSE;

                    // if the payment mode is CARD , check if any default card is available

                    if($user->payment_mode == CARD) {
                        if($user_card = Card::find($user->card_id)) {
                            $allow = DEFAULT_TRUE;
                        }
                    } else {
                        $allow = DEFAULT_TRUE;
                    }

                    // Check the any ongoing requests or assigned requests on user requested date

                    // $response_array = RequestRepo::request_date_validation($request);

                    if($allow == true) {

                        // Get the provider details 

                        if($temp_request->request_type == REQUEST_TYPE_LOCATION) {

                            $response_array = RequestRepo::location_providers_save($request , $temp_request , REQUEST_LATER);  

                        } elseif($temp_request->request_type == REQUEST_TYPE_DIRECT) {

                            // Check the provider id not empty

                            if(!$request->provider_id) {

                                $response_array = ['success' => false , 'error' => Helper::error_message(114) , 'error_code' => 114];

                                return response()->json($response_array , 200);

                            }

                            // Check the provider availability and save the details

                            if(Provider::where('id' , $request->provider_id)->where('is_approved' , PROVIDER_APPROVED)->where('is_available' , PROVIDER_AVAILABLE)->count()) {

                                // if(RequestRepo::check_provider_availability($request->provider_id)) {

                                $response_array = RequestRepo::direct_providers($request ,$temp_request , REQUEST_LATER);

                                if($response_array['success']) {
                                    $temp_request->forceDelete();
                                }   

                            } else {
                                $response_array = ['success' => false , 'error' => Helper::error_message(114) , 'error_code' => 114];
                            }

                        } else {

                            $response = RequestRepo::create($request);

                            if($response['success']) {

                                $request_id = $response['request_id'];

                                $reqeusts_data = [];

                                if($request_id) {

                                    $request_details = Requests::find($request_id);

                                    $reqeusts_data = RequestRepo::single_request_response($request_details);
                                }

                                $response_array = ['success' => true , 'message' => Helper::success_message(206) , 'code' => 206 , 'data' => $reqeusts_data];

                                $temp_request->forceDelete();
                            }
                       
                        }

                    } else {

                        $response_array = ['success' => false , 'error' => Helper::error_message(146) , 'error_code' => 146];

                    }
                
                }
            }
        
        } else {
            $response_array = ['success' => false , 'error' => Helper::error_message(115) , 'error_code' => 115];
        }

        return response()->json($response_array , 200);

    }


    public function update(Request $request) {

        $validator = Validator::make($request->all() , [
                'request_id' => 'required|exists:requests,id',
        ]);

        if($validator->fails()) {

            $errors = implode(',', $validator->messages()->all());

            $response_array = ['success' => false , 'error' => $errors , 'error_code' => 101];

        } else {
            $list_status = [REQUEST_ONGOING, WAITING_PAYMENT_CONFIRM, REQUEST_RATING];

            $requests_query = Requests::where('id' , $request->request_id);

            if($requests_query->whereIn('status' , $list_status)->count()) {

                $response_array = ['success' => false , 'error' => Helper::error_message(117) , 'error_code' => 117];  

            } else {

                $response_array = RequestRepo::update($request);
            }
        }

        return response()->json($response_array, 200);

    }

    public function delete(Request $request) {

        if(!RequestRepo::requests_exists($request)){

            $response_array = ['success' => false , 'error' => $errors , 'error_code' => 101];

        } else {

            $list_status = [REQUEST_ONGOING, WAITING_PAYMENT_CONFIRM, REQUEST_RATING];

            $requests_query = Requests::where('id' , $request->request_id);

            if($requests_query->whereIn('status' , $list_status)->count()) {

                $response_array = ['success' => false , 'error' => Helper::error_message(116) , 'error_code' => 116];  

            } else {

                $requests = $requests_query->delete();

                $response_array = ['success' => true];    
            }
        }

        return response()->json($response_array,200);

    }

}
