<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

// use App\Http\Requests;

use App\Http\Controllers\Controller;

use App\User;

use App\Helpers\Helper;

use App\Repositories\UserRepository as UserRepo;

use App\Repositories\CommonRepository as CommonRepo;

use Socialite;

use Hash;

use Log;

use Setting;

class SocialAuthController extends Controller {

    public function redirect(Request $request) {
    	
        return Socialite::driver($request->provider)->redirect();
    }

    public function callback(Request $request ,$provider) {

    	if($provider == "twitter") {
    		
    		if($request->has('denied')) {
		    	
		    	return redirect('/')->with('flash_error',tr('permission_denied'));

    		}

    	} else {

	    	if(!$request->has('code') || $request->has('denied')) {
			    return redirect('/')->with('flash_error' ,tr('permission_denied'));
			}

		}

		session()->put('state', $request->input('state'));

		if($provider == "twitter") {
			
			$social_user = \Socialite::driver($provider)->user();
			

		} else {

			$social_user = \Socialite::driver($provider)->stateless()->user();

		}

		if($social_user) {

			$user = new User;

			$check_user;

			$user->email = "social".uniqid()."@".Setting::get('site_name').".com";

			// Check the social login has email 

			if($social_user->email) {

				// Check the record exists

				$check_user = User::where('email',$social_user->email)->first();

				if(!$check_user) {

					$user->email = $social_user->email;

				}

			} else {

				// Check social unique ID Already exists
				
				$check_user = User::where('social_unique_id' , $social_user->id)->first();

				if($social_user->email && !User::where('email',$social_user->email)->first()) {

					$user->email = $social_user->email;

				}
			
			}

			if($check_user) {

				$user = $check_user;
			}

			$user->social_unique_id = $social_user->id;

			$user->login_by = $provider;

			if($social_user->name) {

				$user->name = $social_user->name;

			} else {

				$user->name = "Dummy";
			}

			// Save Dummy details

			$user->picture =  asset('placeholder.png');

			if(in_array($provider, array('facebook','twitter'))) {

				if($social_user->avatar_original) {

					$user->picture = $social_user->avatar_original;

				}
			}

			$user->password = Hash::make('123456');

	        $user->token = Helper::generate_token();

	        $user->token_expiry = Helper::generate_token_expiry();

			$user->is_activated = $user->status = $user->is_verified = 1;

			$user->login_status = "user";

    		$user->payment_mode = 'cod';

    		$user->unique_id = uniqid($social_user->name);

    		$user->device_type = $user->register_type = "web";

			if($user->save()) {

				CommonRepo::become_a_provider($user);
			}

			if($user) {
				
		    	auth()->login($user);
			}

	    	return redirect()->route('user.dashboard');

	    } else {

	    	return back()->with('flash_error' , tr('social_error'));

	    }
	}
}
