<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\User;

use App\Provider;

use App\Admin;

use App\Requests;

class SubAdminController extends Controller
{
    /**
     * Function: dashboard()
     * 
     * @uses used to display analytics of the website
     *
     * @created Anjana H
     *
     * @updated Anjana H
     *`
     * @param 
     *
     * @return view page
     */
    public function dashboard() {
       
        $user_count = User::where('login_status','=','user')->count();

        $provider_count = Provider::where('login_status','=','provider')->count();

        $requests_count = Requests::count();

        $recent_providers = Provider::orderBy('created_at' , 'DESC')->get();

        $get_registers = get_register_count();

        $recent_users = get_recent_users();
        
        $total_revenue = total_revenue();

        $view = last_days(10);

        return view('admin.dashboard')
                    ->with('page','dashboard')
                    ->with('sub_page','')
                    ->with('user_count' , $user_count)
                    ->with('provider_count' , $provider_count)
                    ->with('requests_count' , $requests_count)
                    ->with('get_registers' , $get_registers)
                    ->with('view' , $view)
                    ->with('total_revenue' , $total_revenue)
                    ->with('recent_users' , $recent_users)
                    ->with('recent_providers' , $recent_providers);
    }

}
