<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

use App\Helpers\Helper;

class AuthenticateProvider
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = 'provider')
    {
        if (Auth::guard($guard)->guest()) {

            if ($request->ajax() || $request->wantsJson()) {

                return response('Unauthorized.', 401);

            } else {

                return redirect()->guest(route('provider.login.form'));
            }
        }

        // Check the email verification

        if(Auth::guard($guard)->user()->is_verified != PROVIDER_EMAIL_VERIFIED) {

            Auth::guard($guard)->logout();

            return redirect()->route('provider.login.form')->with('flash_error' , Helper::error_message(503)); 

        }

        // check the approved status of the logged in provider

        if(Auth::guard($guard)->user()->is_approved == PROVIDER_DECLINED) {

            Auth::guard($guard)->logout();

            return redirect()->route('provider.login.form')->with('flash_error' , Helper::error_message(502)); 

        }

        return $next($request);
    }
}
