<?php

namespace App\Http\Middleware;

use Closure;

use Illuminate\Http\Request;

use App\Helpers\Helper;

use Validator;

use Log;

use App\Provider;

use DB;


class ProviderApiValidation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $validator = Validator::make(
                $request->all(),
                array(
                        'token' => 'required|min:5',
                        'id' => 'required|integer|exists:providers,id'
                ));
            
        if ($validator->fails()) {

            $errors = implode(',', $validator->messages()->all());

            $response = array('success' => false, 'error' => $errors, 'error_code' => 101);
            
            return $response;

        } else {

            $token = $request->token;

            $provider_id = $request->id;
                
            if (! Helper::is_token_valid('PROVIDER', $provider_id, $token, $error)) {

                $response = response()->json($error, 200);

                return $response;

            } else {

                $provider_details = Provider::find($request->id);

                if(!$provider_details) {
                    
                    $response = array('success' => false , 'error' => Helper::error_message(504) , 'error_code' => 504);
                   
                    return response()->json($response, 200);
                }

                if($provider_details->status == PROVIDER_DECLINED) {
                    
                    $response = array('success' => false , 'error' => Helper::error_message(502) , 'error_code' => 502);
                    
                    return response()->json($response, 200);
                }

                if($provider_details->is_verified == PROVIDER_EMAIL_NOT_VERIFIED) {

                    if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON && !in_array($provider_details->login_by, ['facebook' , 'google'])) {

                        // Check the verification code expiry

                        Helper::check_email_verification("" , $provider_details, $error, PROVIDER);
                        
                        $response = array('success' => false , 'error' => Helper::error_message(503) , 'error_code' => 503);
                        
                        return response()->json($response, 200);

                    }
                }

            }


        }

        return $next($request);
    }
}
