<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

use App\Helpers\Helper;

use App\User;

use Setting;

class WebUserValidation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next , $guard = null)
    {
        if (Auth::check()) {

            $token = Auth::user()->token;

            $user_id = Auth::user()->id;

            if (!Helper::is_token_valid('USER', $user_id, $token, $error)) {

                Auth::logout();
                
                return redirect()->route('user.login.form')->with('flash_error' , isset($error['error']) ? $error['error'] : tr('invalid_token'));

            } else {

                $user_details = User::find($user_id);

                if(!$user_details) {

                    Auth::logout();

                    return redirect()->route('user.login.form')->with('flash_error' , Helper::error_message(504));
                }

                if($user_details->status == USER_DECLINED) {

                    Auth::logout();
                    
                    return redirect()->route('user.login.form')->with('flash_error' , Helper::error_message(502));

                }

                if($user_details->is_verified == USER_EMAIL_NOT_VERIFIED) {

                    if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON) {

                        Auth::logout();

                        // Check the verification code expiry

                        Helper::check_email_verification("" , $user_details, $error, USER);
                        
                        return redirect()->route('user.login.form')->with('flash_error' , Helper::error_message(503));

                    }
                }
            }

        }

        return $next($request);
    }
}
