<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

/*****************************************************************
 *  
 * UI ROUTES
 *
 ****************************************************************/

Route::get('/test' , 'SampleController@test');

Route::get('/welcome_ui' , 'SampleControldelete.cardler@welcome_ui');

Route::get('/forgot_ui' , 'SampleController@forgot_ui');

Route::get('/notification_ui' , 'SampleController@notification_ui');

Route::get('/static_ui' , 'SampleController@static_ui');

Route::get('/invoice' , 'SampleController@invoice');

Route::get('/no_result' , 'SampleController@no_result');

Route::get('/payment_success' , 'SampleController@payment_success');

Route::get('/settings' , 'SampleController@settings');

Route::get('/revenue' , 'SampleController@revenue');

/************ UI ROUTES END ********************/

Route::get('/clear-cache', function() {

    $exitCode = Artisan::call('config:cache');

    return redirect(route('admin.settings'))->with('flash_success',tr('admin_settings_success'));

})->name('clear-cache');


Route::post('/site/status' , 'ApplicationController@site_status');

// Generral configuration routes 

Route::post('project/configurations' , 'ApplicationController@configuration_site');


Route::get('/message/save' , 'ApplicationController@message_save');

Route::post('/message/update/status' , 'ApplicationController@message_update_status')->name("update.message.status");


Route::get('/user_session_language/{lang}', 'ApplicationController@set_session_language')->name('user_session_language');

Route::get('/email/verification' , 'ApplicationController@user_email_verify')->name('email.verify');

Route::get('/email/provider_verification' , 'ApplicationController@provider_email_verify')->name('provider.email.verify');


/****************** STATIC PAGES START ********************/

Route::get('/mobile/page', 'ApplicationController@mobile_static_page')->name('mobile.page');

Route::get('/' , 'ApplicationController@home')->name('home');

Route::get('/how-it-works' , 'ApplicationController@how_it_works')->name('how_it_works');

Route::get('/privacy', 'ApplicationController@privacy')->name('privacy');

Route::get('/terms', 'ApplicationController@terms')->name('terms');

Route::get('/about', 'ApplicationController@about')->name('about');

Route::get('/contact', 'ApplicationController@contact')->name('contact');

Route::get('/help', 'ApplicationController@static_help')->name('static_help');
Route::get('/faq', 'ApplicationController@static_faq')->name('faq');


Route::post('/providers/list', 'UserController@requests_providers_list');

Route::get('/static/help', 'ApplicationController@help')->name('help');

Route::get('/static/terms', 'ApplicationController@static_terms')->name('api.terms');

Route::get('/static/privacy', 'ApplicationController@static_privacy')->name('api.privacy');

Route::get('page/{unique_id}' , 'ApplicationController@other_pages')->name("other.pages");

/****************** STATIC PAGES END ********************/


/****** CRON JOBS STRAT ******/

Route::get('/delete_drafts' , 'ApplicationController@delete_drafts');

Route::get('/assign_next_provider_cron' , 'ApplicationController@assign_next_provider_cron');

Route::get('/cron_later_request_time_exceed_cancel' , 'ApplicationController@cron_later_request_time_exceed_cancel');

Route::get('/check_provider_subscription_expiry_cron' , 'ApplicationController@check_provider_subscription_expiry_cron');


/****** CRON JOBS END ******/


/**** WEB SOCIAL LOGIN *****/

Route::post('/social', array('as' => 'SocialLogin' , 'uses' => 'SocialAuthController@redirect'));

Route::get('/callback/{provider}', 'SocialAuthController@callback');

/**** WEB SOCIAL LOGIN *****/

Route::get('pages/{unique_id}', 'ApplicationController@other_pages')->name('pages');

Route::post('select/sub_category' , 'ApplicationController@select_sub_category')->name('select.sub_category');

Route::any('/categories' , 'ApplicationController@categories')->name('categories');

Route::post('/sub_categories' , 'ApplicationController@sub_categories')->name('subCategories');

Route::get('/payment_modes' , 'ApplicationController@get_payment_modes')->name('paymentModes');

Route::get('register/choose' , 'ApplicationController@choose_register')->name('choose.register');

// User And Provider Switch

Route::get('/become/provider' , 'ApplicationController@become_a_provider')->name('become.provider');

Route::get('/become/user' , 'ApplicationController@become_a_user')->name('become.user');


Route::get('/admin/check_role', 'AdminController@check_role');


/*****************************************************************
 *
 * ADMIN ROUTES
 *
 ****************************************************************/

Route::group(['prefix' => 'admin' , 'as' => 'admin.'], function(){

    Route::get('login', 'Auth\AdminAuthController@showLoginForm')->name('login');

    Route::post('login', 'Auth\AdminAuthController@login')->name('login.post');

    Route::get('logout', 'Auth\AdminAuthController@logout')->name('logout');

    // Registration Routes...

    Route::get('register', 'Auth\AdminAuthController@showRegistrationForm');

    Route::post('register', 'Auth\AdminAuthController@register');

    // Password Reset Routes...
    Route::get('password/reset/{token?}', 'Auth\AdminPasswordController@showResetForm');

    Route::post('password/email', 'Auth\AdminPasswordController@sendResetLinkEmail');

    Route::post('password/reset', 'Auth\AdminPasswordController@reset');

    Route::get('/', 'AdminController@dashboard')->name('dashboard');

    Route::get('/profile', 'AdminController@profile')->name('profile');

	Route::post('/profile/save', 'AdminController@profile_save')->name('profile.save');

	Route::post('/change/password', 'AdminController@change_password')->name('change.password');

    // users

    Route::get('/users', 'AdminController@users_index')->name('users.index');

    Route::get('/users/create', 'AdminController@users_create')->name('users.create');

    Route::get('/users/edit', 'AdminController@users_edit')->name('users.edit');

    Route::post('/users/create', 'AdminController@users_save')->name('users.save');

    Route::get('/users/delete', 'AdminController@users_delete')->name('users.delete');

    Route::get('/users/view', 'AdminController@users_view')->name('users.view');

    Route::get('/user/verify', 'AdminController@users_verify_status')->name('users.verify');

    Route::get('users/status', 'AdminController@users_status_change')->name('users.status');
    
    // User referral list- admin

    Route::get('/users/referral/index', 'AdminController@users_index')->name('users.referral.index');

    // User History - admin

    Route::get('/users/history', 'AdminController@users_history')->name('users.history');
  
    // not being used
    // Route::get('/users/history/delete', 'AdminController@history_delete')->name('users.history.delete');
    
    Route::get('/users/export/', 'AdminExportController@users_export')->name('users.export');

    Route::get('/users/fav_providers', 'AdminController@users_fav_providers')->name('users.fav_providers');

    Route::get('/users/fav_providers/remove', 'AdminController@users_fav_providers_remove')->name('users.fav_providers.remove');
    
    // Providers

    Route::get('/providers', 'AdminController@providers_index')->name('providers.index');

    Route::get('/providers/create', 'AdminController@providers_create')->name('providers.create');

    Route::get('/providers/edit', 'AdminController@providers_edit')->name('providers.edit');

    Route::post('/providers/create', 'AdminController@providers_save')->name('providers.save');

    Route::get('/providers/delete', 'AdminController@providers_delete')->name('providers.delete');

    Route::get('/providers/view', 'AdminController@providers_view')->name('providers.view');

    Route::get('/provider/approve', 'AdminController@providers_status_change')->name('providers.approve');

    Route::get('/provider/verify', 'AdminController@providers_verify_status')->name('providers.verify');

    Route::post('/providers/pay', 'AdminController@providers_pay')->name('providers.pay');

    Route::get('/providers/documents', 'AdminController@providers_documents')->name('providers.document');

    Route::get('/providers/history', 'AdminController@providers_history')->name('providers.history');

    Route::get('/redeems', 'AdminController@redeems_requests')->name('providers.redeems');

    Route::any('/providers/payout/invoice', 'AdminController@providers_redeems_payout_invoice')->name('providers.payout.invoice');

    Route::post('providers/payout/direct', 'AdminController@providers_redeems_payout_direct')->name('providers.payout.direct');

    Route::any('/providers/payout/response', 'AdminController@providers_redeems_payout_response')->name('providers.payout.response');


    Route::get('/provider/services','AdminController@providers_services')->name('providers.services');

    Route::get('/providers/export/', 'AdminExportController@providers_export')->name('providers.export');

    Route::get('/providers/gallery/', 'AdminController@providers_gallery')->name('providers.gallery');

    Route::post('/providers/gallery/', 'AdminController@providers_gallery_save')->name('providers.gallery.save');

    Route::get('/provider/dashboard','AdminController@providers_dashboard')->name('providers.dashboard');


     // categories

    Route::get('/categories', 'AdminController@categories_index')->name('categories.index');

    Route::get('/categories/create', 'AdminController@categories_create')->name('categories.create');

    Route::get('/categories/edit', 'AdminController@categories_edit')->name('categories.edit');

    Route::post('/categories/create', 'AdminController@categories_save')->name('categories.save');

    Route::get('/categories/delete', 'AdminController@categories_delete')->name('categories.delete');


    Route::get('/categories/approve', 'AdminController@categories_status_change')->name('categories.approve');

    // sub categorys

    Route::get('/sub_categories', 'AdminController@sub_categories_index')->name('sub_categories.index');

    Route::get('/sub_categories/create', 'AdminController@sub_categories_create')->name('sub_categories.create');

    Route::get('/sub_categories/edit', 'AdminController@sub_categories_edit')->name('sub_categories.edit');

    Route::post('/sub_categories/create', 'AdminController@sub_categories_save')->name('sub_categories.save');

    Route::get('/sub_categories/delete', 'AdminController@sub_categories_delete')->name('sub_categories.delete');

    Route::get('/sub_categories/status', 'AdminController@sub_categories_status_change')->name('sub_categories.status');

     //Documnets

    Route::get('/documents', 'AdminController@documents_index')->name('documents.index');

    Route::get('/documents/create', 'AdminController@documents_create')->name('documents.create');

    Route::post('/documents/save', 'AdminController@documents_save')->name('documents.save');

    Route::get('/documents/edit', 'AdminController@documents_edit')->name('documents.edit');

    Route::get('/documents/delete', 'AdminController@documents_delete')->name('documents.delete');

    Route::get('/documents/status', 'AdminController@documents_status_change')->name('documents.status');

    Route::get('/payments/export/', 'AdminExportController@payments_export')->name('payments.export');

    // Requests
    Route::get('/requests/ondemand', 'AdminController@requests_ondemand')->name('requests.ondemand');

    Route::get('/requests/bidding', 'AdminController@requests_bidding')->name('requests.bidding');

    Route::get('/requests/view', 'AdminController@requests_view')->name('requests.view');

    Route::get('/requests/history/{id}', 'AdminController@request_history')->name('requests.history');

    Route::get('/requests/export/', 'AdminExportController@requests_export')->name('requests.export');

    Route::get('/requests/fav_providers/', 'AdminController@requests_fav_providers')->name('requests.fav_providers');

    Route::get('/abuse/providers', 'AdminController@abuse_providers_index')->name('abuse.providers.index'); 

    Route::post('/requests/cancel', 'AdminController@requests_cancel')->name('requests.cancel');


    // Coupons

    // Get the list of coupon details
    Route::get('/coupons/','AdminController@coupons_index')->name('coupons.index');

    // Get the add coupon forms
    Route::get('/coupons/create','AdminController@coupons_create')->name('coupons.create');

    // Get the edit coupon forms
    Route::get('/coupons/edit','AdminController@coupons_edit')->name('coupons.edit');

    // Save the coupon details
    Route::post('/coupons/save','AdminController@coupons_save')->name('coupons.save');

    //Get the particular coupon details
    Route::get('/coupons/view','AdminController@coupons_view')->name('coupons.view');

    // Delete the coupon details
    Route::get('/coupons/delete','AdminController@coupons_delete')->name('coupons.delete');
    
    //Coupon approve and decline status
    Route::get('/coupons/status','AdminController@coupons_status_change')->name('coupons.status');

    //ios control settings

    // Get ios control page
    Route::get('/ios-control','AdminController@ios_control')->name('ios_control');

    //Save the ios control status
    Route::post('/ios-control/save','AdminController@ios_control_save')->name('ios_control.save');
    
    

    //Reviews & Ratings

    Route::get('/user_reviews', 'AdminController@user_reviews')->name('user_reviews');

    Route::get('/user_reviews/delete', 'AdminController@user_reviews_delete')->name('user_reviews.delete');

    Route::get('/provider_reviews', 'AdminController@provider_reviews')->name('provider_reviews');

    Route::get('/provider_reviews/delete', 'AdminController@provider_reviews_delete')->name('provider_reviews.delete');



    // Settings

    Route::get('settings' , 'AdminController@settings')->name('settings');

    Route::post('settings' , 'AdminController@settings_save')->name('settings.save');

    Route::post('save_common_settings' , 'AdminController@common_settings_save')->name('common-settings.save');
    
    Route::get('help' , 'AdminController@help')->name('help');

    // Controls Route

    Route::get('control','AdminController@controls_create')->name('control.settings');

    Route::post('control','AdminController@controls_save')->name('save.control');

    
    //Banner Image

    Route::get('/bannerimagess', 'AdminController@banners_index')->name('banners.index');

    Route::get('/bannerimages/create', 'AdminController@banners_create')->name('banners.create');

    Route::post('/bannerimages/save', 'AdminController@banners_save')->name('banners.save');

    Route::get('/bannerimages/edit', 'AdminController@banners_edit')->name('banners.edit');

    Route::get('/bannerimages/delete', 'AdminController@banners_delete')->name('banners.delete');

    Route::get('/bannerimages/status', 'AdminController@banners_status_change')->name('banners.status');

    // Pages

    Route::get('/static-pages/index' , 'AdminController@static_pages_index')->name('static_pages.index');

    Route::get('/static-pages/create' , 'AdminController@static_pages_create')->name('static_pages.create');

    Route::post('/static-pages/save' , 'AdminController@static_pages_save')->name('static_pages.save');

    Route::get('/static-pages/edit' , 'AdminController@static_pages_edit')->name('static_pages.edit');

    Route::post('/static-pages/edit' , 'AdminController@static_pages_save')->name('static_pages.edit.save');

    Route::get('/static-pages/delete' , 'AdminController@static_pages_delete')->name('static_pages.delete');

   // Languages

    Route::get('/languages/index', 'LanguageController@languages_index')->name('languages.index'); 

    Route::get('/languages/download/', 'LanguageController@languages_download')->name('languages.download'); 

    Route::get('/languages/create', 'LanguageController@languages_create')->name('languages.create');
    
    Route::get('/languages/edit', 'LanguageController@languages_edit')->name('languages.edit');

    Route::get('/languages/status', 'LanguageController@languages_status_change')->name('languages.status');   

    Route::post('/languages/save', 'LanguageController@languages_save')->name('languages.save');

    Route::get('/languages/delete', 'LanguageController@languages_delete')->name('languages.delete');


    Route::get('/languages/set_default_language/{name}', 'LanguageController@set_default_language')->name('languages.set_default');


    // Template
    Route::get('email_templates', 'TemplateController@email_template_index')->name('templates.email_template_index');

    Route::get('email_template_view', 'TemplateController@email_template_view')->name('templates.email_template_view');

    Route::get('email_template_edit', 'TemplateController@email_template_edit')->name('templates.email_template_edit');

    Route::post('save_email_template', 'TemplateController@save_email_template')->name('templates.save_email_template');

    Route::get('email_template_credential', 'TemplateController@email_template_credential')->name('templates.email_template_credential');

    Route::get('sms_templates', 'TemplateController@sms_template_index')->name('templates.sms_template_index');

    Route::get('sms_template_view', 'TemplateController@sms_template_view')->name('templates.sms_template_view');

    Route::get('sms_template_edit', 'TemplateController@sms_template_edit')->name('templates.sms_template_edit');

    Route::post('save_sms_template', 'TemplateController@save_sms_template')->name('templates.save_sms_template');

    Route::get('sms_template_credential', 'TemplateController@sms_template_credential')->name('templates.sms_template_credential');

    Route::get('notification_templates', 'TemplateController@notification_template_index')->name('templates.notification_template_index');

    Route::get('notification_template_view', 'TemplateController@notification_template_view')->name('templates.notification_template_view');

    Route::get('notification_template_edit', 'TemplateController@notification_template_edit')->name('templates.notification_template_edit');

    Route::post('save_notification_template', 'TemplateController@save_notification_template')->name('templates.save_notification_template');

    Route::get('notification_template_credential', 'TemplateController@notification_template_credential')->name('templates.notification_template_credential');

    // revenues

    Route::get('/revenues' , 'AdminController@revenues')->name('revenues');

    // User Payment details
    
    Route::get('requests/payments' , 'AdminController@requests_payments')->name('requests.payments');

    //ProviderSubscription Methods.

    Route::get('provider_subscriptions/index', 'AdminController@provider_subscriptions_index')->name('provider_subscriptions.index');

    Route::get('provider_subscriptions/edit', 'AdminController@provider_subscriptions_edit')->name('provider_subscriptions.edit'); 

    Route::get('provider_subscriptions/create', 'AdminController@provider_subscriptions_create')->name('provider_subscriptions.create');

    Route::post('provider_subscriptions/save', 'AdminController@provider_subscriptions_save')->name('provider_subscriptions.save');

    Route::get('provider_subscriptions/view', 'AdminController@provider_subscriptions_view')->name('provider_subscriptions.view');

    Route::get('provider_subscriptions/delete', 'AdminController@provider_subscriptions_delete')->name('provider_subscriptions.delete');

    Route::get('provider_subscriptions/status', 'AdminController@provider_subscriptions_status_change')->name('provider_subscriptions.status.change');

   Route::get('provider_subscriptions/is_popular', 'AdminController@provider_subscriptions_is_popular')->name('provider_subscriptions.is_popular');
   
    Route::get('provider_subscriptions/payments', 'AdminController@provider_subscriptions_payments')->name('provider_subscriptions.payments');

    Route::get('provider_subscriptions/plans', 'AdminController@provider_subscriptions_plans')->name('provider_subscriptions.plans');

    Route::get('provider/subscriptions/plans/save', 'AdminController@provider_subscriptions_plans_save')->name('providers.subscriptions.plans.save');

    Route::post('provider/subscriptions/disable', 'AdminController@provider_auto_subscription_disable')->name('providers.subscriptions.cancel');

    Route::get('/provider/subscriptions/enable', 'AdminController@provider_auto_subscription_enable')->name('providers.subscriptions.enable');

    // Sub Admins CRUD Operations

    Route::get('sub_admins/index', 'AdminController@sub_admins_index')->name('sub_admins.index');

    Route::get('sub_admins/create', 'AdminController@sub_admins_create')->name('sub_admins.create');

    Route::get('sub_admins/edit', 'AdminController@sub_admins_edit')->name('sub_admins.edit');

    Route::get('sub_admins/view', 'AdminController@sub_admins_view')->name('sub_admins.view');

    Route::get('sub_admins/status', 'AdminController@sub_admins_status')->name('sub_admins.status');

    Route::get('sub_admins/delete', 'AdminController@sub_admins_delete')->name('sub_admins.delete');

    Route::post('sub_admins/save', 'AdminController@sub_admins_save')->name('sub_admins.save');
        
});

/*****************************************************************
 *
 * WEB USER ROUTES
 *
 ****************************************************************/

Route::group(['as' => 'user.'], function() {

    Route::get('/home' , 'UserController@index')->name('dashboard');

    Route::get('login', 'Auth\AuthController@showLoginForm')->name('login.form');

    Route::post('login', 'Auth\AuthController@login')->name('login.post');

    Route::get('logout', 'Auth\AuthController@logout')->name('logout');

    Route::get('login/choose' , 'ApplicationController@user_choose_login')->name('choose.login');


    // Registration Routes...
    Route::get('register', 'Auth\AuthController@showRegistrationForm')->name('register.form');

    Route::post('register', 'Auth\AuthController@register')->name('register.save');

    // Password Reset Routes...
    Route::get('password/reset/{token?}', 'Auth\PasswordController@showResetForm')->name('password.reset');

    Route::post('password/email', 'Auth\PasswordController@sendResetLinkEmail')->name('password.email');

    Route::post('password/reset', 'Auth\PasswordController@reset')->name('password.reset.save');

    Route::get('profile', 'UserController@profile')->name('profile');

    Route::get('profile/image', 'UserController@profile_image_save')->name('profile.image.save');

    Route::post('update/profile', 'UserController@profile_save')->name('profile.save');

    Route::post('/profile/password', 'UserController@profile_change_password')->name('profile.change.password');

    // Card 

    Route::post('cards/add' , 'UserController@cards_add')->name('cards.add');

    Route::get('/cards/delete' , 'UserController@cards_delete')->name('cards.delete');

    Route::get('/cards/default' , 'UserController@cards_default')->name('cards.default');


    // Delete Account

    Route::post('delete/account', 'UserController@delete_account')->name('delete.account');


    /***** DRAFTS MANAGEMENT ******/

    Route::get('jobs/draft_edit/{request_id}' , 'UserController@requests_draft_edit')->name('requests.draft.edit');

    Route::get('requests/draft/delete/{id}' , 'UserController@requests_draft_delete')->name('requests.draft.delete');

    /***** DRAFTS MANAGEMENT ******/

    /***** REQUEST CREATE MANAGEMENT ******/

    Route::get('jobs' , 'UserController@jobs_index')->name('jobs.index');

    Route::get('jobs/create' , 'UserController@jobs_create')->name('jobs.create');

    Route::get('jobs/edit/{request_unique_id}' , 'UserController@requests_update')->name('requests.update');

    Route::post('jobs/edit' , 'UserController@requests_update_save')->name('requests.update.save');

    Route::get('jobs/view/{request_unique_id?}' , 'UserController@requests_view')->name('jobs.view');

    Route::get('tasker/{provider_id}/{request_id?}', 'UserController@provider_profile')->name('tasker.profile');

    Route::get('chat/{request_id}/{provider_id}', 'UserController@chat')->name('chat');

    /***** REQUEST CREATE MANAGEMENT ******/

    /***** REQUEST FLOW MANAGEMENT ******/

    // JOB FLOW 

    Route::post('/jobs/status/check/now' , 'UserController@request_status_check_now')->name('requests.status.check.now');

    Route::post('/jobs/status/check/later' , 'UserController@request_status_check_later')->name('requests.status.check.later');
    
    Route::post('jobs/assign' , 'UserController@requests_later_assign')->name('jobs.assign');

    Route::post('jobs/reject' , 'UserController@requests_reject')->name('jobs.reject');

    Route::post('requests/cancel' , 'UserController@requests_cancel')->name('jobs.cancel');

    Route::post('requests/payment' , 'UserController@requests_payment')->name('requests.payment');

    Route::post('coupon/apply' , 'UserController@coupon_code_apply')->name('coupon.apply');

    Route::post('requests/rating' , 'UserController@requests_rating')->name('requests.rating');

    Route::post('refresh/request' , 'UserController@refresh_single_request')->name('requests.refresh.single');

    Route::get('history' , 'UserController@requests_history')->name('history');

    /***** REQUEST FLOW MANAGEMENT ******/


    // Notifications

    Route::get('notifications' , 'UserController@notifications')->name('notifications');


    Route::get('/message/get', 'UserController@requests_chat_history')->name('requests.chat');

    // Ajax Requests

    Route::post('ajax_draft_requests', 'UserController@ajax_draft_requests')->name('ajax_draft_requests');

    Route::any('cancelled_requests', 'UserController@cancelled_requests')->name('cancelled_requests');

    Route::post('ajax_posted_requests', 'UserController@ajax_posted_requests')->name('ajax_posted_requests');

    Route::post('ajax_confirmed_requests', 'UserController@ajax_confirmed_requests')->name('ajax_confirmed_requests');

    Route::post('ajax_ongoing_requests', 'UserController@ajax_ongoing_requests')->name('ajax_ongoing_requests');


    Route::get('see_all_notifications', 'UserController@see_all_notifications')->name('notification.see_all');

    Route::get('user_fav_providers_remove' , 'UserController@user_fav_providers_remove')->name('user_fav_providers_remove');

    Route::get('/referrals', 'UserController@referrals')->name('referrals');

    Route::get('/referrals/view', 'UserController@referrals_view')->name('referrals.view');

});

/*****************************************************************
 *
 * WEB PROVIDER ROUTES
 *
 ****************************************************************/

Route::group(['as' => 'provider.' , 'prefix' => 'provider'], function() {

    Route::any('/' , 'ProviderController@index')->name('dashboard');

    Route::get('login', 'Auth\ProviderAuthController@showLoginForm')->name('login.form');

    Route::post('login', 'Auth\ProviderAuthController@login')->name('login.post');

    Route::get('logout', 'Auth\ProviderAuthController@logout')->name('logout');

    Route::get('login/choose' , 'ApplicationController@provider_choose_login')->name('choose.login');

    // Registration Routes...
    Route::get('register', 'Auth\ProviderAuthController@showRegistrationForm')->name('register.form');

    Route::post('register/agree' , 'ProviderController@register_agree')->name('register.agree');


    Route::post('register', 'Auth\ProviderAuthController@register')->name('register.save');

    // Password Reset Routes...
    Route::get('password/reset/{token?}', 'Auth\ProviderPasswordController@showResetForm')->name('password.reset');

    Route::post('password/email', 'Auth\ProviderPasswordController@sendResetLinkEmail')->name('password.email');

    Route::post('password/reset', 'Auth\ProviderPasswordController@reset')->name('password.reset.save');

    Route::get('profile', 'ProviderController@profile')->name('profile');

   
    Route::get('gallery', 'ProviderController@gallery')->name('gallery');

    Route::post('update/profile', 'ProviderController@profile_save')->name('profile.save');

    Route::post('/profile/password', 'ProviderController@profile_change_password')->name('profile.change.password');

    Route::post('/gallery/save', 'ProviderController@galleries_save')->name('gallery.save');

    Route::get('/gallery/delete', 'ProviderController@galleries_delete')->name('gallery.delete');

    // Payment Update

    Route::post('/payment/update', 'ProviderController@payment_update')->name('payment.update');

     // Redeems

    Route::get('send/redeem', 'ProviderController@send_redeem_request')->name('redeems.send.request');

    Route::get('redeem/request/cancel/{id?}', 'ProviderController@redeem_request_cancel')->name('redeems.request.cancel');

    // Documents

    Route::post('/documents/upload', 'ProviderController@documents_upload')->name('documents.upload');

    Route::get('/documents/delete/{id}', 'ProviderController@documents_delete')->name('documents.delete');

    // Requests

    Route::post('/change/state', 'ProviderController@change_state')->name('change.state');

    Route::get('/detect/request', 'ProviderController@detect_request')->name('detect.request');



    // Services

    Route::get('services' , 'ProviderController@services')->name('services');

    Route::post('register/services' , 'ProviderController@register_services')->name('register.services');

    Route::post('services/save' , 'ProviderController@services_save')->name('services.save');

    // Location 

    Route::get('location' , 'ProviderController@location')->name('location');

    Route::post('location' , 'ProviderController@location_save')->name('location.save');


    // // Delete Account

    Route::post('delete/account', 'ProviderController@delete_account')->name('delete.account');

    Route::get('delete/account/success', 'ProviderController@delete_account_success')->name('delete.account.success');

    // Jobs 

    Route::get('/jobs' , 'ProviderController@index')->name('requests.view');

    Route::get('requests/view/{unique_id}' , 'ProviderController@requests_view')->name('requests.view');

    Route::get('/incoming/request', 'ProviderController@incoming_request')->name('incoming.request');

    Route::get('/requests/accept', 'ProviderController@accept_request')->name('request.accept');

    Route::get('/requests/decline', 'ProviderController@decline_request')->name('request.decline');

    Route::get('history' , 'ProviderController@history')->name('history');


    Route::get('chat/{request_id}/{user_id}', 'ProviderController@chat')->name('chat');

    Route::post('refresh/request' , 'ProviderController@refresh_single_request')->name('requests.refresh.single');

    Route::post('requests/send/bid' , 'ProviderController@send_bid_request')->name('requests.send.bid');
    Route::post('requests/confirm' , 'ProviderController@confirm_request')->name('requests.confirm');

    Route::post('requests/cancel' , 'ProviderController@request_cancel')->name('requests.cancel');

    // Route::get('seeker/{id}', 'ProviderController@user_profile')->name('seeker.profile');

    Route::get('seeker/{id}/{request_id?}', 'ProviderController@user_profile')->name('user.profile');

    Route::get('check/provider/started', 'ProviderController@check_provider_started')->name('check.provider.started');

    Route::post('/switch/state', 'ProviderController@switch_state')->name('switch.state');

    Route::post('/payment/confirm', 'ProviderController@request_payment_confirm')->name('payment.confirm');

    Route::post('requests/rating' , 'ProviderController@request_rating')->name('requests.rating');


    Route::get('/requests/chat', 'ProviderController@requests_chat_history')->name('requests.chat');

    // Ajax Reposne

    Route::post('ajax_new_requests', 'ProviderController@ajax_new_requests')->name('ajax_new_requests');

    Route::post('ajax_direct_requests', 'ProviderController@ajax_direct_requests')->name('ajax_direct_requests');

    Route::post('ajax_bidded_requests', 'ProviderController@ajax_bidded_requests')->name('ajax_bidded_requests');

    Route::post('ajax_confirmed_requests', 'ProviderController@ajax_confirmed_requests')->name('ajax_confirmed_requests');

    Route::post('ajax_ongoing_requests', 'ProviderController@ajax_ongoing_requests')->name('ajax_ongoing_requests');

    Route::get('see_all_notifications', 'ProviderController@see_all_notifications')->name('notification.see_all');

    // Provider Subscriotion

    Route::get('/subscriptions/history', 'ProviderController@subscriptions_history')->name('subscriptions.history');

    Route::get('/subscriptions/index', 'ProviderController@subscriptions_index')->name('subscriptions.index');

    Route::post('subscriptions/save', 'ProviderController@subscriptions_save')->name('subscriptions.save');

    Route::get('/subscriptions/invoice', 'ProviderController@subscriptions_invoice')->name('subscriptions.invoice');

    Route::get('/cards', 'ProviderController@cards_index')->name('cards');

    Route::post('card/add', 'ProviderController@cards_add')->name('add.card');

    Route::get('/delete/card', 'ProviderController@cards_delete')->name('delete.card'); 

    Route::get('/default/card', 'ProviderController@cards_default')->name('default.card'); 

    Route::get('/revenues', 'ProviderController@revenues')->name('revenues');

});

/*****************************************************************
 *
 * USER API ROUTES
 *
 ****************************************************************/

Route::group(['prefix' => 'api/user'], function() {

    Route::post('project/configurations' , 'ApplicationController@configuration_site');

    Route::post('/register','UserApiController@register');
    
    Route::post('/login','UserApiController@login');

    Route::post('/profile','UserApiController@profile');

    Route::post('/update_profile', 'UserApiController@update_profile');

    Route::post('/forgot_password', 'UserApiController@forgot_password');

    Route::post('/change_password', 'UserApiController@change_password');

    Route::post('/delete_account', 'UserApiController@delete_account');

    Route::post('/settings', 'UserApiController@settings');

    Route::post('/logout', 'UserApiController@logout');

    Route::post('/search', 'UserApiController@search');
 
    // Categories And SubCategories

    Route::post('/categories' , 'UserApiController@get_categories');

    // Route::post('/subCategories' , 'UserApiController@get_sub_categories');

    // Payment Modes

    Route::post('/payment_modes' , 'UserApiController@get_user_payment_modes');

    Route::post('/payment_mode_update' , 'UserApiController@payment_mode_update');

    Route::post('/card_add' , 'UserApiController@cards_add');

    //Get Braintree Token
    Route::post('/getbraintreetoken' , 'UserApiController@getBraintreeToken');

    Route::post('/card_delete' , 'UserApiController@cards_delete');

    Route::post('/card_default' , 'UserApiController@cards_default');

    // Requests

    Route::post('request_draft' , 'RequestsController@draft_request');

    Route::post('drafts' , 'UserApiController@drafts');

    // Route::post('request_providers' , 'RequestsController@providers_list');

    Route::post('request_providers' , 'UserApiController@providers_list');

    Route::post('request_now' , 'RequestsController@request_now');
    
    Route::post('request_later' , 'RequestsController@request_later');
    
    Route::post('request_update' , 'UserApiController@request_update');

    Route::post('request_status_check_now' , 'UserApiController@request_status_check_now');

    Route::post('request_status_check_later' , 'UserApiController@request_status_check_later');
    
    Route::post('request_details' , 'UserApiController@request_details');

    Route::post('request_later_details' , 'UserApiController@request_later_details');

    Route::post('waiting_request_cancel' , 'UserApiController@waiting_request_cancel');

    Route::post('assign_request' , 'UserApiController@assign_request');

    Route::post('reject_request' , 'UserApiController@reject_request');

    Route::post('cancel_request' , 'UserApiController@cancel_request');

    Route::post('paynow' , 'UserApiController@requests_payment');

    Route::post('coupon/apply' , 'UserApiController@coupon_code_apply');

    Route::post('request_rating' , 'UserApiController@requests_rating');

    Route::post('history' , 'UserApiController@history');

    Route::post('single_request' , 'UserApiController@single_request');

    Route::post('posted_requests' , 'UserApiController@posted_requests');

    Route::post('confirmed_requests' , 'UserApiController@confirmed_requests');

    Route::post('ongoing_requests' , 'UserApiController@ongoing_requests');

    Route::post('/message/get', 'UserApiController@requests_chat_history');

    Route::post('/provider/profile', 'UserApiController@provider_details');

    Route::post('/bids', 'UserApiController@requests_bids');

    Route::post('user_notifications', 'UserApiController@user_notifications');

    Route::post('change_status_notifications', 'UserApiController@change_status_notifications');

    Route::post('change_confirmed_notifications', 'UserApiController@change_confirmed_notifications');

    Route::post('change_ongoing_notifications', 'UserApiController@change_ongoing_notifications');

    Route::post('user_notifications', 'UserApiController@user_notifications');

    // Fav providers

    Route::post('fav_providers', 'UserApiController@fav_providers');

    Route::post('fav_providers/remove', 'UserApiController@fav_providers_remove');

    // Referrals 

    Route::post('/referrals', 'UserApiController@referrals')->name('referrals');

    Route::post('/referrals_check', 'UserApiController@referrals_check');

});

/*****************************************************************
 *
 * PROVIDER API ROUTES
 *
 ****************************************************************/

Route::group(['prefix' => 'api/provider'], function() {

    Route::post('project/configurations' , 'ApplicationController@configuration_site');


    Route::post('register','ProviderApiController@register');
    
    Route::post('login','ProviderApiController@login');

    Route::post('profile','ProviderApiController@profile');

    Route::post('update_profile', 'ProviderApiController@update_profile');

    Route::post('forgot_password', 'ProviderApiController@forgot_password');

    Route::post('change_password', 'ProviderApiController@change_password');

    Route::post('delete_account', 'ProviderApiController@delete_account');

    Route::post('/logout', 'ProviderApiController@logout');

    // Payment Details

    Route::post('/payment/update', 'ProviderApiController@payment_update');


    Route::post('settings', 'ProviderApiController@settings');

    Route::post('categories', 'ProviderApiController@categories');
    
    Route::post('sub_categories', 'ProviderApiController@sub_categories');
   
    Route::post('services', 'ProviderApiController@services');
    
    Route::post('services_save', 'ProviderApiController@services_save');
    
    Route::post('services_remove', 'ProviderApiController@services_remove');

    // documents

    Route::post('location_update' , 'ProviderApiController@location_update');

    Route::post('check_available' , 'ProviderApiController@check_available');

    Route::post('available_update' , 'ProviderApiController@available_update');

    // Request Status 

    Route::post('request_details' , 'ProviderApiController@request_details');

    Route::post('incoming_request' , 'ProviderApiController@incoming_request');
    
    Route::post('user_profile' , 'ProviderApiController@user_profile');

    Route::post('request_status_check' , 'ProviderApiController@request_status_check');
    
    Route::post('request_accept' , 'ProviderApiController@request_accept');

    Route::post('request_reject' , 'ProviderApiController@request_reject');

    Route::post('send_bid_request' , 'ProviderApiController@send_bid_request');

    Route::post('confirm_request' , 'ProviderApiController@confirm_request');

    Route::post('cancel_request' , 'ProviderApiController@request_cancel');

    Route::post('reject_bidding_request' , 'ProviderApiController@request_bidding_reject');

    // Request Flow

    Route::post('check_provider_started' , 'ProviderApiController@check_provider_started');
    
    Route::post('provider_started' , 'ProviderApiController@provider_started');

    Route::post('provider_arrived' , 'ProviderApiController@provider_arrived');

    Route::post('request_started' , 'ProviderApiController@request_started');

    Route::post('request_completed' , 'ProviderApiController@request_completed');

    Route::post('request_payment_confirm' , 'ProviderApiController@request_payment_confirm');

    Route::post('request_rating' , 'ProviderApiController@request_rating');

    Route::post('history' , 'ProviderApiController@history');

    Route::post('single_request' , 'ProviderApiController@single_request');

    // Dashboard

    Route::post('available_requests' , 'ProviderApiController@available_requests');
    
    Route::post('direct_requests' , 'ProviderApiController@direct_requests');

    Route::post('bidded_requests' , 'ProviderApiController@bidded_requests');

    Route::post('confirmed_requests' , 'ProviderApiController@confirmed_requests');

    Route::post('ongoing_requests' , 'ProviderApiController@ongoing_requests');

    Route::any('/message/get', 'ProviderApiController@requests_chat_history');
    
    Route::post('provider_notifications', 'ProviderApiController@provider_notifications');

    Route::post('change_status_notifications', 'ProviderApiController@change_status_notifications');

    Route::post('change_job_status_notifications', 'ProviderApiController@change_job_status_notifications');

    Route::post('change_direct_notifications', 'ProviderApiController@change_direct_notifications');


    Route::post('/redeems/list', 'ProviderApiController@redeems');

    Route::post('redeems/send_request', 'ProviderApiController@send_redeem_request');

    Route::post('redeems/request/cancel', 'ProviderApiController@redeem_request_cancel');

    // Gallery

    Route::post('/gallery', 'ProviderApiController@galleries_index')->name('gallery.index');

    Route::post('/gallery/save', 'ProviderApiController@galleries_save')->name('gallery.save');

    Route::post('/gallery/delete', 'ProviderApiController@galleries_delete')->name('gallery.delete');

    // Version 3.0 provider routes


    // CARDS curd Operations

    Route::post('cards_list', 'ProviderApiController@cards_list'); // 16

    Route::post('cards_add', 'ProviderApiController@cards_add'); // 15

    Route::post('cards_default', 'ProviderApiController@cards_default'); // 18

    Route::post('cards_delete', 'ProviderApiController@cards_delete'); // 17


    Route::post('subscriptions', 'ProviderApiController@subscriptions');

    Route::post('subscriptions_payment_by_stripe', 'ProviderApiController@subscriptions_payment_by_stripe');

    Route::post('subscriptions_history', 'ProviderApiController@subscriptions_history');

    // Notification status 
    Route::post('notifications_status_update', 'ProviderApiController@notifications_status_update');

    Route::post('revenues', 'ProviderApiController@revenues');
});

Route::get('v4_migration_upgrade', 'ApplicationController@v4_migration_upgrade');

// V4.0 
Route::group(['middleware' => ['SubAdminMiddleware', 'admin'], 'prefix' => 'subadmin', 'as' => 'subadmin.'], function () {

    Route::get('/', 'SubAdminController@dashboard')->name('dashboard');

    Route::get('subadmin/profile', 'SubAdminController@profile')->name('profile');

});

// Referral link generate

Route::get('/rc/{referral_code}', 'UserController@referrals_signup')->name('referrals_signup');
