<?php

namespace App\Jobs;

use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

use App\Jobs\Job;
use App\Helpers\Helper;
use App\User;
use App\Provider;
use Setting;
use Log;

class sendPushNotification extends Job implements ShouldQueue {

    use InteractsWithQueue, SerializesModels;

    protected $id;
    protected $user_type;
    protected $page_id;
    protected $title;
    protected $message;
    protected $current_request_status;
    protected $request_id;
    protected $page_type;
    protected $chat_data;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($id,$user_type,$page_id,$title,$message , $current_request_status = 0 , $request_id = "" , $page_type = "" , $chat_data = []) {

        $this->id = $id;
        $this->user_type = $user_type;
        $this->page_id = $page_id;
        $this->title = $title;
        $this->message = $message;
        $this->current_request_status = $current_request_status;
        $this->request_id = $request_id;
        $this->page_type = $page_type;
        $this->chat_data = $chat_data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle() {

        // Check the push notifictaion is enabled

        $push_notification = Setting::get('push_notification'); 

        if ($push_notification) {

            // Check whether Browser Key Set or Not

            if(Setting::get('browser_key')) {

                Log::info("Request Push Notification Queue Started");

                // Get the request details

                // Check the user type whether "USER" or "PROVIDER"
                if($this->user_type == USER) {

                    $user = User::find($this->id);
                    
                } else {

                    $user = Provider::find($this->id);
                }


                $push_message = ['success' => true,'message' => $this->message];

                if ($user->device_type == 'ios') {

                    Log::info("iOS push Started");

                    if($this->user_type == USER) {

                        require_once app_path().'/ios/apns.php';

                    } else {

                        require_once app_path().'/ios/provider-apns.php';    
                    }

                    Log::info($user->device_token);

                    $msg = array(
                        "alert" => "" . $this->title,
                        "status" => "success",
                        'newrequest' => "$this->current_request_status",
                        "title" => $this->title,
                        "badge" => 1,
                        "sound" => "default",
                        );

                    if (!isset($user->device_token) || empty($user->device_token)) {
                        $deviceTokens = array();
                    } else {
                        $deviceTokens = $user->device_token;
                    }

                    $apns = new \Apns();
                    $apns->send_notification($deviceTokens, $msg );

                    Log::info("iOS push end");

                } else {

                    Log::info("Andriod Push Notification");
                    
                    Log::info("Andriod Push Message".$this->message);

                    $data = ['request_id' => "$this->request_id" , 'page_type' => "$this->page_type"];

                    if(in_array($this->page_id , [PUSH_USER_CHAT , PUSH_PROVIDER_CHAT])) {

                        $data = array_merge($data , $this->chat_data);

                    }

                    Log::info("DATA".print_r($data , true));
                    
                    $push_message = ['success' => true,'title' => $this->message,'type' => $this->page_id,'data' => $data];

                    Log::info("Andriod push Started");

                    require_once app_path().'/gcm/GCM_1.php';

                    require_once app_path().'/gcm/const.php';

                    if (!isset($user->device_token) || empty($user->device_token)) {
                        $registatoin_ids = "0";
                    } else {
                        $registatoin_ids = trim($user->device_token);
                    }
                    
                    if (!isset($push_message) || empty($push_message)) {
                        $push_message = "Message not set";
                    } else {
                        $push_message = $push_message;
                    }

                    if (!isset($this->title) || empty($this->title)) {
                        $title1 = "Message not set";
                    } else {
                        $title1 = trim($this->title);
                    }

                    $message = array(TEAM => $title1, MESSAGE => $push_message);

                    Log::info('Push Message   ********************************'.print_r($message,true));

                    $gcm = new \GCM();
                    $registatoin_ids = array($registatoin_ids);
                    $gcm->send_notification($registatoin_ids, $message);

                    Log::info("Andriod push end");
                }

            } else {
                Log::info("browser_key empty");
            }

        } else {
            Log::info('Push notifictaion is not enabled. Please contact admin');
        }
           
    }
}
