<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use App\ProviderNotification;

class ProviderNotification extends Model
{

    public static function save_notification($provider, $content, $user_id, $request_id, $status) {

    	$model = new ProviderNotification;

    	$model->provider_id = $provider->id;

    	$model->notification = $content;

        $model->user_id = $user_id;

        $model->request_id = $request_id;

    	if ($status == ON_DEMAND_REQUEST) {

    		$model->job_status = DEFAULT_TRUE;

    	}

    	if ($status == ON_LATER_REQUEST_DIRECT) {

    		$model->job_status = 2;

    	}

        if ($status == USER_BIDDING_ACCEPT) {

            $model->job_status = 3;

        }

    	$model->save();


    }


    public function provider() {
        return $this->belongsTo('App\Provider');
    }

    public function user() {
        return $this->belongsTo('App\User');
    }
}
