<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class ProviderRating extends Model
{

    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];
    
    public function user() {
    	return $this->belongsTo('App\User');
    }

    public function provider() {
    	return $this->belongsTo('App\Provider');
    }

    public function requests() {
    	return $this->belongsTo('App\Requests','request_id');
    }
}
