<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class ProviderService extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];
    
    public function category() {
    	return $this->belongsTo('App\Category');
    }

    public function subCategory() {
    	return $this->belongsTo('App\SubCategory');
    }

    public function provider() {
    	return $this->belongsTo('App\Provider');
    }
}
