<?php

namespace App\Repositories;

use App\Helpers\Helper;

use App\Language;

use App\User;

use Validator, DB ,Hash, Log, Exception;

class AdminRepository
{
    public static function languages_save($request) {

        try {
            
            DB::beginTransaction();

            $validator = Validator::make($request->all(),[                 
                'folder_name' => 'required|max:4',
                'language'=>'required|max:64',
                'auth_file'=> !($request->language_id) ? 'required' : '',
                'messages_file'=>!($request->language_id) ? 'required' : '',
                'pagination_file'=>!($request->language_id) ? 'required' : '',
                'passwords_file'=>!($request->language_id) ? 'required' : '',
                'validation_file'=>!($request->language_id) ? 'required' : '',
            ]);
            
            if($validator->fails()) {

                $error = implode(',', $validator->messages()->all());

                throw new Exception($error, 101);
            } 
            
            \Log::info("language_files: validation done ");

            if ($request->language_id) {
                 
                $language_details = Language::find($request->language_id);
                
                $lang = $language_details->folder_name;

             } else {

                $language_details = new Language;

                $language_details->status = APPROVED;

                $lang = $language_details->folder_name = $request->folder_name;

            }

            $language_files_array['auth_file'] = 'auth.php'; 
           
            $language_files_array['messages_file'] = 'messages.php'; 
           
            $language_files_array['pagination_file'] = 'pagination.php';
           
            $language_files_array['passwords_file'] = 'passwords.php'; 
           
            $language_files_array['validation_file'] = 'validation.php';

            foreach ($language_files_array as $key => $value) {
                        
                if($request->hasFile($key)) {
                    
                    // Read File Length
                    \Log::info("language_files: ".$key." exists");

                    $originallength = readFileLength(base_path().'/resources/lang/en/'.$value);

                    $length = readFileLength($_FILES[$key]['tmp_name']);

                    if($originallength != $length) {

                        throw new Exception(Helper::error_message(162), 162);
                    }

                    if($language_details->id != '') {
                                                
                        Helper::delete_language_files($lang, DEFAULT_FALSE , $value);
                    }   

                    Helper::upload_language_file($lang, $request->$key, $value);
                }

            }
            
            $language_details->language = $request->language;

            /** Check if language folder name changed and update **/
            if ($request->language_id) {

                if($language_details->folder_name != $request->folder_name) {

                    $current_folder = base_path('resources/lang/'.$language_details->folder_name);

                    $new_folder = base_path('resources/lang/'.$request->folder_name);

                    rename($current_folder,$new_folder);

                    $language_details->folder_name = $request->folder_name;
                }
            }

            if( $language_details->save()) {
                
                DB::commit();

                $response_array = ['success' => true, 'message'=> $request->id != '' ? tr('language_update_success') : tr('language_create_success')];
                
                return $response_array;

            } 

            throw new Exception(tr('something_error'), 101);
           
        } catch (Exception $e) {
            
            DB::rollback();

            $error = $e->getMessage();
            
            $code = $e->getCode();
            
            $response_array = ['success' => false , 'error' => $error, 'code' => $code];
            return $response_array;

        }

    }
}
