<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

use App\Helpers\Helper;

class Requests extends Model
{
    use SoftDeletes;


    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];
    
	public function user() {
		return $this->belongsTo('App\User');
	}

	public function provider() {
		return $this->belongsTo('App\Provider');
	}

    public function category() {
        return $this->belongsTo('App\Category');
    }

    public function subCategory() {
        return $this->belongsTo('App\SubCategory');
    }

    public function abuseProviders() {
        return $this->belongsTo('App\AbuseProvider');
    }

    public function favProviders() {
        return $this->belongsTo('App\UserFavProvider');
    }

	public function requestMeta() {
		return $this->hasMany('App\RequestsMeta' , 'request_id');
	}

    public function bids() {
        return $this->hasMany('App\RequestsMeta' , 'request_id')->orderBy('requests_meta.updated_at' , 'desc')->whereIn('status' , [REQUEST_META_BID,REQUEST_META_ASSIGNED]);
    }

	public function chat() {
		return $this->hasMany('App\ChatMessage' , 'request_id');
	}

	public function payments() {
		return $this->hasOne('App\RequestPayment' , 'request_id');
	}

	public function providerRatings() {
		return $this->belongsTo('App\ProviderRating');
	}

	public function userRatings() {
		return $this->belongsTo('App\UserRating');
	}
    
    public static function boot() {

        //execute the parent's boot method 
        parent::boot();

        //delete your related models here, for example
        
        static::deleting(function($data) {

            if(count($data->requestMeta) > 0) {

                foreach($data->requestMeta as $meta) {
                    $meta->forceDelete();
                } 

            }

            if(count($data->chat) > 0) {

                foreach($data->chat as $requestChat) {
                    $requestChat->forceDelete();
                } 
             
            }

            if(count($data->abuseProviders) > 0) {

                foreach($data->abuseProviders as $abuseProvider) {
                    $abuseProvider->forceDelete();
                } 
            
            }

            if(count($data->favProviders) > 0) {

                foreach($data->favProviders as $favProvider) {
                    $favProvider->forceDelete();
                } 
            
            }

            if(count($data->payments) > 0) {

                $data->payments->forceDelete();
            
            }

            if(count($data->userRatings) > 0) {

                foreach($data->userRatings as $userRating) {
                    $userRating->forceDelete();
                } 
        
            }

            if(count($data->providerRatings) > 0) {

                foreach($data->providerRatings as $providerRating) {
                    $providerRating->forceDelete();
                } 
            
            }
        }); 

    }
}
