<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class RequestsMeta extends Model {

    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];
	
	protected $table = 'requests_meta';

    public function metaUser() {
    	return $this->belongsTo('App\User' , 'user_id');
    }

    public function metaProvider() {
    	return $this->belongsTo('App\Provider' , 'provider_id');
    }

    public function requests() {
    	return $this->belongsTo('App\Requests' , 'request_id');
    }

}
