<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

use App\Helpers\Helper;

class SubCategory extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];

    /**
     * Scope a query to only include active users.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeBaseResponse($query) {

        $currency = \Setting::get('currency' , '$');

        return $query->where('categories.status' , 1)
                    ->leftJoin('categories' , 'sub_categories.category_id' , '=' , 'categories.id')
                    ->where('sub_categories.status' , 1)
                    ->orderBy('categories.name' , 'desc')
                    ->select(
                        'category_id','sub_categories.id as sub_category_id' , 
                        'sub_categories.name as sub_category_name' , 
                        'sub_categories.description as sub_category_description' , 
                        'sub_categories.picture as sub_category_picture' , 
                        'sub_categories.unique_id' , 'sub_categories.status' , 
                        'sub_categories.price',
                        \DB::raw("'$currency' as currency")
                    );
    }
    
    public function category() {
    	return $this->belongsTo('App\Category');
    }

    public function requests() {
    	return $this->hasMany('App\Requests');
    }

    public function providerServices() {
    	return $this->hasMany('App\ProviderService');
    }

    public static function boot() {
        
        //execute the parent's boot method 
        parent::boot();

        //delete your related models here, for example
        static::deleting(function($data) {

            Helper::delete_avatar('uploads/sub-category' , $data->picture);

            if(count($data->requests) > 0) {

                foreach($data->requests as $subCategoryRequest) {
                 
                    $subCategoryRequest->delete();
                } 
            }

            if(count($data->providerServices) > 0) {

                foreach($data->providerServices as $providerService) {

                    $providerService->delete();
                } 
            }
            
        }); 

    }
}
