<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class TempRequests extends Model
{
    use SoftDeletes;

     /**
     * Scope a query to only include active users.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeTempResponse($query,$id)
    {
        return $query->where('temp_requests.id' , $id)
            ->join('categories' , 'categories.id' , '=' , 'temp_requests.category_id')
            ->join('sub_categories' , 'sub_categories.id' , '=' , 'temp_requests.sub_category_id')
            ->select('temp_requests.id as temp_request_id', 
                'temp_requests.user_id',
                'temp_requests.provider_id',
                'temp_requests.job_type',
                'temp_requests.request_type',
                'temp_requests.category_id',
                'categories.name as category_name',
                'temp_requests.sub_category_id',
                'sub_categories.name as sub_category_name',
                'temp_requests.request_date',
                'temp_requests.name',
                'temp_requests.description',
                'temp_requests.note',
                'temp_requests.s_latitude',
                'temp_requests.s_longitude',
                'temp_requests.s_address',
                'temp_requests.step',
                'temp_requests.status',
                'temp_requests.user_price'
                );
    }

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    
    protected $dates = ['deleted_at'];
    
    public function user() {
        return $this->belongsTo('App\User');
    }

    public function provider() {
        return $this->belongsTo('App\Provider');
    }

    public function category() {
        return $this->belongsTo('App\Category');
    }

    public function subCategory() {
        return $this->belongsTo('App\SubCategory');
    }

    /**
     * Scope a query to only include active users.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeTempRequestResponse($query,$id)
    {
        return $query->where('temp_requests.id' , $id)->select(
                'temp_requests.id as temp_request_id', 
                'temp_requests.user_id', 
                'temp_requests.provider_id', 
                'temp_requests.name' , 
                'temp_requests.description' , 
                'temp_requests.job_type',
                'temp_requests.request_type',
                'temp_requests.category_id',
                'temp_requests.sub_category_id',
                'temp_requests.note',
                'temp_requests.s_latitude',
                'temp_requests.s_longitude',
                'temp_requests.d_latitude',
                'temp_requests.d_longitude',
                'temp_requests.user_price',
                'temp_requests.status',
                'temp_requests.step'
                );
    }
}
