<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use App\UserNotification;

class UserNotification extends Model
{
    //
    public static function save_notification($user, $content, $provider_id, $request_id, $status) {

    	$model = new UserNotification;

    	$model->user_id = $user->id;

    	$model->notification = $content;

        $model->provider_id = $provider_id;

        $model->request_id = $request_id;

    	if ($status == PROVIDER_ACCEPT_REQUEST) {

    		$model->job_status = 1;

    	}

    	if ($status == PROVIDER_STARTED_REQUEST) {

    		$model->job_status = 2;
    		
    	}

    	$model->save();

    }

    public function provider() {
        return $this->belongsTo('App\Provider');
    }

    public function user() {
        return $this->belongsTo('App\User');
    }
}
