<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->string('name');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('token');
            $table->string('picture');
            $table->enum('gender',array('male','female','others'));
            $table->string('description');
            $table->string('mobile');
            $table->string('address');
            $table->double('latitude', 15, 8);
            $table->double('longitude',15,8);
            $table->string('social_unique_id');
            $table->string('dob');
            $table->string('token_expiry');
            $table->string('device_token');
            $table->enum('device_type',array('web','android','ios'));
            $table->enum('login_by',array('manual','facebook','google','twitter' , 'linkedin', 'others'));
            $table->string('payment_mode');
            $table->integer('card_id'); 
            $table->integer('is_activated');
            $table->integer('status');
            $table->integer('provider_id')->comment="PROVIDER ID";
            $table->string('login_status')->comment="Last Login By Email - provider , user";
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
