<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProvidersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('providers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->string('name');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email');
            $table->string('password');
            $table->string('picture');
            $table->string('token');
            $table->string('token_expiry');
            $table->string('device_token');
            $table->enum('device_type',array('web','android','ios'));
            $table->enum('login_by',array('manual','facebook','google'));
            $table->double('latitude', 15, 8);
            $table->double('longitude',15,8);
            $table->string('social_unique_id');
            $table->string('description');
            $table->enum('gender',array('male','female','others'));
            $table->string('mobile');
            $table->string('address');
            $table->integer('status');
            $table->integer('is_approved');
            $table->integer('is_activated');
            $table->integer('is_available');
            $table->integer('user_id')->comment="User ID";
            $table->string('login_status')->comment="Last Login By Email - provider , user";
            $table->integer('waiting_to_respond')->comment="On Demand Job , 1 - Having Current Job , 0 - Free Now";
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('providers');
    }
}
