<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->integer('user_id');
            $table->integer('provider_id');
            $table->integer('job_type')->comment="1- Request Now , 2 - LATER Request";
            $table->integer('request_type')->comment="1 - LOCATION , 2 - CATEGORY , 3 - Direct";
            $table->integer('category_id');
            $table->integer('sub_category_id');
            $table->dateTime('request_date')->comment="User requested start time";
            $table->dateTime('request_start_time')->comment="User requested time";
            $table->string('name');
            $table->string('description');
            $table->string('note');
            $table->double('s_latitude',15,8);
            $table->double('s_longitude',15,8);
            $table->double('d_latitude',15,8);
            $table->double('d_longitude',15,8);
            $table->string('s_address');
            $table->string('d_address');
            $table->dateTime('assign_time')->comment="Job Assigned date";
            $table->dateTime('confirm_time')->comment="Job Confirmed date By provider";
            $table->dateTime('start_time')->comment="Job Work started date";
            $table->dateTime('end_time')->comment="Job completed date";
            $table->float('user_price')->comment="Initial Price Set By User";
            $table->float('price_per_hour')->comment="Final Price set by user";
            $table->string('payment_mode');
            $table->string('currency');
            $table->float('total');
            $table->tinyInteger('is_paid');
            $table->integer('step');
            $table->integer('status')->comment="0 - REQUEST_NONE, 1 - REQUEST_CREATED , 2 - REQUEST_WAITING , 3 - REQUEST_PROVIDER_ASSIGNED  , 4 - REQUEST_ONGOING , 5 - WAITING_PAYMENT_CONFIRM , 6 - REQUEST_RATING , 7 - REQUEST_COMPLETED ,8 - REQUEST_CANCELLED , 9 - REQUEST_REASSIGNED , 10 - REQUEST_NO_PROVIDER_AVAILABLE";

            $table->integer('provider_status')->comment="0 - PROVIDER_NONE , 1 - PROVIDER_BID_SEND , 2 - PROVIDER_ASSIGNED , 3 - PROVIDER_ACCEPTED , 4 - PROVIDER_STARTED , 5 - PROVIDER_ARRIVED , 6  - PROVIDER_SERVICE_STARTED , 7 - PROVIDER_SERVICE_COMPLETED ,  8 - PROVIDER_RATED";

            $table->string('cancelled_by')->comment="admin, user , provider";
            $table->dateTime('cancelled_date');
            $table->string('image')->comment="Upload images By User";
            $table->string('before_image');
            $table->string('after_image');
            // $table->text('user_reason');
            // $table->text('provider_reason');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('requests');
    }
}
