<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTempRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('temp_requests', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->integer('provider_id');
            $table->integer('request_type')->comment="1 - LOCATION , 2 - CATEGORY , 3 - Direct";
            $table->integer('job_type')->comment="1- Request Now , 2 - LATER Request ";
            $table->integer('category_id');
            $table->integer('sub_category_id');
            $table->dateTime('request_date')->comment="User requested start time";
            $table->string('name');
            $table->string('description');
            $table->string('note');
            $table->double('s_latitude',15,8);
            $table->double('s_longitude',15,8);
            $table->double('d_latitude',15,8);
            $table->double('d_longitude',15,8);
            $table->string('s_address');
            $table->string('d_address');
            $table->integer('step');
            $table->integer('status');
            $table->float('user_price');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('temp_requests');
    }
}
