<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddWalletFieldToProviderPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('provider_payments', function (Blueprint $table) {
            $table->float('admin_commission')->before('total');
            $table->float('provider_amount')->before('admin_commission');
            $table->float('pending_amount')->after('provider_amount');
            $table->float('wallet')->after('pending_amount');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('provider_payments', function (Blueprint $table) {
            $table->dropColumn('admin_commission');
            $table->dropColumn('provider_amount');
            $table->dropColumn('pending_amount');
            $table->dropColumn('wallet');
        });
    }
}
