<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToRedeemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('redeems', function (Blueprint $table) {
            $table->integer('provider_id')->after('id');
            $table->float('total')->after('provider_id');
            $table->float('paid')->after('total');            
            $table->float('remaining')->after('paid');
            $table->float('total_admin_amount')->after('remaining');
            $table->float('total_provider_amount')->after('total_admin_amount');
            $table->integer('status')->after('total_provider_amount');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('redeems', function (Blueprint $table) {
            $table->dropColumn('provider_id');
            $table->dropColumn('total');
            $table->dropColumn('paid');            
            $table->dropColumn('remaining');
            $table->dropColumn('total_admin_amount');
            $table->dropColumn('total_provider_amount');
            $table->dropColumn('status');
        });
    }
}
