<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddV2FieldsToRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('requests', function (Blueprint $table) {
            $table->string('price_type')->before('payment_mode');
            $table->string('price_per_symbol')->before('price_type');
            $table->integer('is_fav_provider')->after('provider_status');
            $table->integer('is_abused_provider')->after('is_fav_provider');
            $table->text('cancelled_reason')->after('cancelled_date');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('requests', function (Blueprint $table) {
            $table->dropColumn('cancelled_reason');
            $table->dropColumn('price_type');
            $table->dropColumn('price_per_symbol');
            $table->dropColumn('is_fav_provider');
            $table->dropColumn('is_abused_provider');
        });
    }
}
