<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCouponRelatedFieldsToRequestPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('request_payments', function (Blueprint $table) {
            $table->string('coupon_code')->before('total');
            $table->string('coupon_type')->after('coupon_code');
            $table->float('coupon_amount')->after('coupon_type');
            $table->integer('is_coupon_applied')->after('coupon_amount');
            $table->text('coupon_reason')->after('is_coupon_applied');
            $table->string('currency')->after('coupon_reason');
            $table->float('sub_total')->after('currency');
            $table->float('actual_total')->after('sub_total');
            

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('request_payments', function (Blueprint $table) {
            $table->dropColumn('coupon_code');
            $table->dropColumn('coupon_type');
            $table->dropColumn('coupon_amount');
            $table->dropColumn('is_coupon_applied');
            $table->dropColumn('coupon_reason');
            $table->dropColumn('currency');
            $table->dropColumn('sub_total');
            $table->dropColumn('actual_total');
        });
    }
}
