<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProviderSubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('provider_subscriptions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id')->nullable();
            $table->string('title');
            $table->text('description')->default("");
            $table->string('picture')->nullable();
            $table->float('amount')->default(0.00);
            $table->string('plan')->default(0);
            $table->string('plan_type')->default('month')->comment="day,month,year";
            $table->dateTime('expiry_date')->nullable();
            $table->tinyInteger('status')->default(APPROVED);
            $table->tinyInteger('is_popular')->default(NO);
            $table->tinyInteger('is_free_subscription')->default(NO);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('provider_subscriptions');
    }
}
