<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProviderCardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('provider_cards', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->integer('provider_id');
            $table->string('customer_id');
            $table->string('last_four');
            $table->string('card_token');
            $table->integer('is_default');
            $table->string('card_type')->default('na');
            $table->string('card_name');
            $table->string('month',4);
            $table->string('year',4);
            $table->boolean('is_deleted')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('provider_cards');
    }}
