<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProviderSubscriptionPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('provider_subscription_payments', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('provider_id');
            $table->integer('provider_subscription_id');
            $table->string('payment_id');
            $table->float('amount');
            $table->float('paid_amount'); 
            $table->string('payment_mode')->default(0.00);
            $table->dateTime('expiry_date');
            $table->integer('is_current_subscription')->default(0);
            $table->float('subscription_amount')->default(0.00);
            $table->integer('is_cancelled')->default(0);
            $table->string('cancelled_reason')->default("");
            $table->string('subscribed_by')->default("");
            $table->tinyInteger('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('provider_subscription_payments');
    }
}
