<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V4Migrations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('providers', function (Blueprint $table) {
            $table->integer('is_email_notification')->default(YES);
            $table->integer('is_sms_notification')->default(YES);
            $table->integer('is_push_notification')->default(YES);
            $table->integer('provider_type')->default(NO);
            $table->integer('provider_card_id')->default(NO);
        });

        Schema::create('user_referrers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->integer('user_id');
            $table->string('referral_code');
            $table->integer('total_referrals')->default(0);
            $table->float('total_referrals_earnings')->default(0);
            $table->integer('status')->default(1);
            $table->timestamps();
        });

        Schema::create('referrals', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unique_id');
            $table->integer('user_id');
            $table->integer('parent_user_id');
            $table->integer('user_referrer_id');
            $table->string('referral_code');
            $table->string('source');            
            $table->integer('status')->default(1);
            $table->timestamps();
        });

        Schema::table('request_payments', function (Blueprint $table) {
            $table->integer('provider_id')->after('user_id');
            $table->integer('is_paid')->default(0)->after('status');
            $table->dateTime('paid_date')->nullable()->after('is_paid');
        });

        Schema::table('admins', function (Blueprint $table) {
            $table->string('role')->default(ADMIN)->after('status');
        });

        Schema::table('provider_subscriptions', function (Blueprint $table) {
            $table->integer('category_id')->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('providers', function (Blueprint $table) {
            $table->dropColumn('is_email_notification');
            $table->dropColumn('is_sms_notification');
            $table->dropColumn('is_push_notification');
            $table->dropColumn('provider_type');
            $table->dropColumn('provider_card_id');
        });

        Schema::table('request_payments', function (Blueprint $table) {
            $table->dropColumn('provider_id');
            $table->dropColumn('is_paid');
            $table->dropColumn('paid_date');
        });

        Schema::drop('referrals');

        Schema::drop('user_referrers');

        Schema::table('admins', function (Blueprint $table) {
            $table->dropColumn('role');
        });

        Schema::table('provider_subscriptions', function (Blueprint $table) {
            $table->dropColumn('category_id');
        });
        
    }
}
