<?php

use Illuminate\Database\Seeder;

use App\Helpers\Helper;

class ProviderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if(Schema::hasTable('providers')) {
            
    		$data = DB::table('providers')->whereIn('email' ,['provider@gentack.info' , 'test@gentack.info'])->delete();

         	DB::table('providers')->insert([
	    		[
	    			'unique_id' => uniqid("Provider"),
			        'name' => 'Provider',
			        'email' => 'provider@gentack.info',
			        'password' => \Hash::make('123456'),
			        'picture' => "http://gentack.info/placeholder.png",
			        'token'=>Helper::generate_token(),
                	'token_expiry'=>Helper::generate_token_expiry(),
			        'status' => 1,
			        'is_approved' => 1,
			        'is_available' => 1,
			        'is_verified' => 1,
			        'step' => PROVIDER_STEP_INITIAL,
			        'login_by' => 'manual',
			        'login_status' => 'provider',
			        'register_type' => 'web',
			        'device_type' => 'web',
			        'created_at' => date('Y-m-d H:i:s'),
			        'updated_at' => date('Y-m-d H:i:s')
			    ],

			    [
	    			'unique_id' => uniqid("Test-Provider"),
			        'name' => 'Test Provider',
			        'email' => 'test@gentack.info',
			        'password' => \Hash::make('123456'),
			        'picture' => "http://gentack.info/placeholder.png",
			        'token'=>Helper::generate_token(),
                	'token_expiry'=>Helper::generate_token_expiry(),
			        'status' => 1,
			        'is_approved' => 1,
			        'is_available' => 1,
			        'is_verified' => 1,
			        'step' => PROVIDER_STEP_INITIAL,
			        'login_by' => 'manual',
			        'login_status' => 'provider',
			        'register_type' => 'web',
			        'device_type' => 'web',
			        'created_at' => date('Y-m-d H:i:s'),
			        'updated_at' => date('Y-m-d H:i:s')
			    ],
			]);

		}

    }
}
