<?php

use Illuminate\Database\Seeder;

use App\Helpers\Helper;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	if(Schema::hasTable('users')) {
            
    		$user = DB::table('users')->whereIn('email' ,['user@gentack.info' , 'test@gentack.info'])->delete();

	        DB::table('users')->insert([
	    		[
	    			'unique_id' => uniqid("User"),
			        'name' => 'User',
			        'email' => 'user@gentack.info',
			        'password' => \Hash::make('123456'),
			        'picture' => "http://gentack.info/placeholder.png",
			        'token'=>Helper::generate_token(),
                	'token_expiry'=>Helper::generate_token_expiry(),
			        'status' => 1,
			        'is_verified' => 1,
			        'login_by' => 'manual',
			        'payment_mode' => 'cod',
			        'login_status' => 'user',
			        'device_type' => 'web',
			        'created_at' => date('Y-m-d H:i:s'),
			        'updated_at' => date('Y-m-d H:i:s')
			    ],

			    [
	    			'unique_id' => uniqid("Test-User"),
			        'name' => 'Test User',
			        'email' => 'test@gentack.info',
			        'password' => \Hash::make('123456'),
			        'picture' => "http://gentack.info/placeholder.png",
			        'token'=>Helper::generate_token(),
                	'token_expiry'=>Helper::generate_token_expiry(),
			        'status' => 1,
			        'is_verified' => 1,
			        'login_by' => 'manual',
			        'payment_mode' => 'cod',
			        'login_status' => 'user',
			        'device_type' => 'web',
			        'created_at' => date('Y-m-d H:i:s'),
			        'updated_at' => date('Y-m-d H:i:s')
			    ],
			]);
		}
    }
}
