# {%= name %} {%= badge('fury') %}

> {%= description %}

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var parsePath = require('{%= name %}');
parsePath('foo/bar/baz/index.md.html');

// returns
{
  name: 'index',
  dirname: 'foo/bar/baz',
  extname: '.md.html',
  basename: 'index.md.html',
  extSegments: ['.md', '.html']
}
```

## Differences from node.js path

Given the following string:

```js
var str = 'foo/bar/baz/quux.min.js';
```

#### .basename

Node.js:

* `path.basename(str)` => `quux.min.js`
* `path.basename(str, path.extname(str))` => `quux.min` **whaaaaa!?**

parse-filepath:

* `parsePath(str).basename` => `quux.min.js`
* `parsePath(str).name` => `quux`


#### .extname

Node.js:

* `path.extname(str)` => `.js`

parse-filepath

* `parsePath(str).extname` => `.min.js`


#### .dotfiles

As an example, `.travis.yml` is parsed to:

```js
{
  name: 'travis',
  dirname: '.',
  extname: '.yml',
  basename: '.travis.yml',
  extSegments: ['.yml']
}
```

And `.gitignore` is parsed to:

```js
{
  name: 'gitignore',
  dirname: '.',
  extname: '',
  basename: '.gitignore',
  extSegments: []
}
```

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}