@extends('layouts.admin')

@section('title', tr('abuse_providers'))

@section('content-header', tr('abuse_providers'))

@section('breadcrumb')

    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

    <li class="active"><i class="fa fa-info"></i> {{ tr('abuse_providers') }}</li>
    
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b>{{ tr('abuse_providers') }}</b>

	            </div>
            
	            <div class="box-body">

					@if(count($abuse_providers) > 0)

		              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th>{{ tr('id') }}</th>
							      <th>{{ tr('user') }}</th>
							      <th>{{ tr('provider') }}</th>
							      <th>{{ tr('request') }}</th>
							      <th>{{ tr('comment') }}</th>
							      <th>{{ tr('date') }}</th>
							      <!-- <th>{{ tr('action') }}</th> -->
							    </tr>
							</thead>

							<tbody>

								@foreach($abuse_providers as $i => $abuse_provider_details)

								    <tr>
								      	<td>{{ showEntries($_GET,$i+1) }}</td>

								      	<td>
								      		<a href="{{ route('admin.users.view' , ['user_id' => $abuse_provider_details->user_id] ) }}">
								      		{{ $abuse_provider_details->user->name ?? "" }}
								      		</a>
								      	</td>

								      	<td>
								      		<a href="{{ route('admin.providers.view' , ['provider_id' => $abuse_provider_details->provider_id] ) }}">
								      			{{ $abuse_provider_details->provider->name ?? "" }}
								      		</a>
								      	</td>

								      	<td>

								      		@if($abuse_provider_details->requests)

								      		<a href="{{ route('admin.requests.view' , [ 'request_unique_id' => $abuse_provider_details->requests->unique_id] ) }}">
								      			{{ $abuse_provider_details->requests ? $abuse_provider_details->requests->name : "" }}
								      		</a>

								      		@endif

								      	</td>

								      	<td>

								      		@if($abuse_provider_details->userRating)

								      			{{ $abuse_provider_details->userRating ? $abuse_provider_details->userRating->comment : "" }}

								      		@endif

								      	</td>

								     	<td>
								     		{{ $abuse_provider_details->created_at ? $abuse_provider_details->created_at->diffForHumans() : "-" }}
								     	</td>

								    </tr>

								@endforeach

							</tbody>

						</table>

						<div align="right">{{ $abuse_providers->links() }}</div>

					@else

						<h3 class="no-result">{{ tr('no_result_found') }}</h3>

					@endif
				
	            </div>

          	</div>

        </div>
        
    </div>

@endsection
