
<form  action="{{ Setting::get('admin_demo_control') ? '#' : route('admin.banners.save') }}" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <input type="hidden" name="banner_id" value="{{ $bannerimage_details->id }}">

        <div class="form-group">

            <label for="banner_title" >{{ tr('banner_title') }}</label>

            <input type="text" class="form-control" name="banner_title" id="banner_title" maxlength="100" placeholder="{{ tr('banner_title') }}" value="{{ old('banner_title') ?: $bannerimage_details->banner_title }}" autofocus>

        </div>

        <div class="form-group">

            <label for="banner_text" >{{ tr('banner_text') }}</label>

            <input type="text" class="form-control" name="banner_text" id="banner_text" maxlength="150" placeholder="{{ tr('banner_text') }}" value="{{ old('banner_text') ?: $bannerimage_details->banner_text }}">

        </div>

        <div class="form-group">

            <label for="picture">{{ tr('picture') }} <span class="form-req">*</span></label>

            <input type="file" class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" required>           

            <br>
            
            @if( $bannerimage_details->picture )

                <img style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="{{ $bannerimage_details->picture }}" accept="image/*">

           @endif

        </div>
    
    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger">{{ tr('reset') }}</button>
        @if(Setting::get('admin_demo_control'))
        <button type="button" class="btn btn-success pull-right" disabled>{{ tr('submit') }}</button>
        @else
        <button type="submit" class="btn btn-success pull-right">{{ tr('submit') }}</button>
        @endif
            
    </div>

</form>