@extends('layouts.admin')

@section('title', tr('bannerimages'))

@section('content-header', tr('bannerimages'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-picture-o"></i> {{ tr('bannerimages') }}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">

            <div class="box box-success">


                <div class="box-header with-border admin-panel-success">

                    <b>{{ tr('bannerimages') }}</b>

                    <a href="{{ route('admin.banners.create') }}" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> {{ tr('add_bannerimage') }}</b>
                    </a>

                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                              <th>{{ tr('id') }}</th>
                              <th>{{ tr('banner_title') }}</th>
                              <th>{{ tr('banner_text') }}</th>
                              <th>{{ tr('image') }}</th>
                              <th>{{ tr('view') }}</th>
                              <th>{{ tr('status') }}</th>
                              <th>{{ tr('action') }}</th>
                            </tr>
                        </thead>

                        <tbody>

                            @foreach($banners as $i => $banner_details)
                    
                                <tr>
                                    <td>{{ showEntries($_GET,$i+1) }}</td>

                                    <td>{{ $banner_details->banner_title ? $banner_details->banner_title : "-" }}</td>

                                    <td>{{ $banner_details->banner_text ? $banner_details->banner_text : "-" }}</td>

                                    <td>
                                        <img style="height: 30px;" src="{{ $banner_details->picture }}">
                                    </td>

                                    <td>
                                        <a href="{{  $banner_details->picture  }}" target="_blank">
                                            <span class="btn btn-info btn-large">{{ tr('view') }}</span>
                                        </a>
                                    </td>

                                    <td>
                                        @if($banner_details->status == COMMON_APPROVED)
                                            <span class="label label-success">{{ tr('approved') }}</span>
                                        @else
                                            <span class="label label-warning">{{ tr('pending') }}</span>
                                        @endif
                                    </td>

                                    <td>
                                        
                                        <div class="dropdown">
                                            
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                {{ tr('action') }}
                                                <span class="caret"></span>
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                @if(Setting::get('admin_demo_control'))
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('edit') }}</b></a>
                                                    </li>
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('delete') }}</b></a>
                                                    </li>

                                                @else

                                                    <li>
                                                        <a href="{{ route('admin.banners.edit', ['banner_id' => $banner_details->id] ) }}"><b>{{ tr('edit') }}</b></a>
                                                    </li>

                                                    <li>
                                                        <a onclick="return confirm(&quot;{{  tr('admin_bannerimage_delete_confirmation' , $banner_details->banner_title)  }}&quot;)"  href="{{ route('admin.banners.delete',['banner_id' => $banner_details->id] ) }}"><b>{{ tr('delete') }}</b></a>
                                                    </li>

                                                @endif
                                                    
                                                <li class="divider" role="presentation"></li>

                                                <li>

                                                    @if(Setting::get('admin_demo_control'))
                                                        
                                                        @if($banner_details->status == COMMON_APPROVED)
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                                <b>{{ tr('decline') }}</b>
                                                            </a>

                                                        @else

                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                                <b>{{ tr('approve') }}</b>
                                                            </a>

                                                        @endif

                                                    @else

                                                        @if($banner_details->status == COMMON_APPROVED)

                                                            <a onclick="return confirm(&quot;{{ $banner_details->banner_title }} - {{  tr('bannerimage_decline_confirmation')  }}&quot;);" href="{{ route('admin.banners.status',array('banner_id' => $banner_details->id)) }}"><b>{{ tr('decline') }}</b></a>

                                                        @else

                                                            <a href="{{ route('admin.banners.status',array('banner_id' => $banner_details->id)) }}"><b>{{ tr('approve') }}</b></a>

                                                        @endif

                                                    @endif

                                                </li>

                                            </ul>

                                        </div>
                                    
                                    </td>
                                
                                </tr>

                            @endforeach

                        </tbody>
                        
                    </table>

                    <div align="right">{{ $banners->links() }}</div>
                
                </div>

            </div>

        </div>
        
    </div>

@endsection