@extends('layouts.admin')

@section('title', tr('bannertext'))

@section('content-header', tr('bannertext'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"><i class="fa fa-book"></i> {{tr('bannertext')}}</li>
@endsection

@section('content')

  	<div class="row">

	    <div class="col-md-10">

	        @include('notification.notify')

	        <div class="box box-primary">

	            <div class="box-header label-primary">
	                <b>{{tr('bannertext')}}</b>
	                
	            </div>

   	            <form  action="{{ Setting::get('admin_delete_control') == YES ? '#' : {{route('admin.bannertext.save')}} " method="POST" enctype="multipart/form-data" role="form">

	                <div class="box-body">
	                    <div class="form-group">
	                        <label for="name">{{tr('bannertext')}}</label>
	                        <textarea class="form-control" name="description" id="name">{{($data) ? $data->value :''}}</textarea>
	                    </div>

	                </div>

	              <div class="box-footer">
	                    <button type="reset" class="btn btn-danger">{{tr('cancel')}}</button>
	                    <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>
	              </div>

	            </form>
	        
	        </div>

	    </div>

	</div>
   
@endsection

