
<form action="{{ Setting::get('admin_demo_control') == YES ? '#' : route('admin.categories.save') }}" method="POST" enctype="multipart/form-data" role="form">
                    
    <input type="hidden" name="category_id" value="{{ $category_details->id }}">

    <div class="box-body">

        <div class="form-group">

            <label for="categoryname">{{ tr('name') }} * </label>

            <input type="text" required name="name" class="form-control" id="categoryname" value="{{ old('name') ?: $category_details->name }}" placeholder="{{ tr('category_name') }}" autofocus>
        </div>

        <div class="form-group">
            <label for="description">{{ tr('description') }} * </label>
            
            <input type="text" required class="form-control" id="description" name="description" value="{{ old('description') ?: $category_details->description }}" placeholder="{{ tr('description') }}">
        </div>

        <div class="form-group">
            <label for="picture">{{ tr('picture') }} *</label>
            
            <input type="file" class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFileview(this,'image_preview')" accept="image/*" @if(!$category_details->id)required @endif>
            
            <br>

            @if( $category_details->id != '')
                <img id="image_preview" style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="{{ $category_details->picture}}">
          	@endif

        </div>
        
    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger">{{tr('reset')}}</button>
        @if(Setting::get('admin_demo_control'))
        <button type="button" class="btn btn-success pull-right" disabled>{{tr('submit')}}</button>
        @else
        <button type="submit" class="btn btn-success pull-right">{{tr('submit')}}</button>
        @endif
        
    </div>

</form>

            