@extends('layouts.admin')

@section('title', tr('add_category'))

@section('content-header', tr('add_category'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li><a href="{{route('admin.categories.index')}}"><i class="fa fa-suitcase"></i> {{tr('categories')}}</a></li>
    <li class="active">{{tr('add_category')}}</li>
@endsection

@section('content')

    <div class="row">

        <div class="col-md-10 col-md-offset-1">
            
            @include('notification.notify')

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b>{{tr('add_category')}}</b>

                    <a href="{{route('admin.categories.index')}}" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-eye"></i> {{tr('view_categories')}}</b>
                    </a>
                </div>

                @include('admin.categories._form')

            </div>

        </div>

    </div>

@endsection


@section('scripts')

    <script type="text/javascript">
        
        function loadFileview(event, id) {

            var ext = $("#picture").val();

            var fileExtension = ['jpeg','jpg','png'];
          
            if($.inArray(ext.split('.').pop().toLowerCase(), fileExtension) == -1) {
                
                alert("Only formats allowed are : "+fileExtension.join(','));
               
                document.getElementById("picture").value = null;                    
                
                return false;

            } else {

                $("#"+id).show();
            
                var reader = new FileReader();

                reader.onload = function(){

                var output = document.getElementById(id);
            
                output.src = reader.result;
                
                };

                reader.readAsDataURL(event.files[0]);
            } 
        }

    </script>

@endsection
