@extends('layouts.admin')

@section('title', tr('categories'))

@section('content-header', tr('categories'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-suitcase"></i> {{ tr('categories') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

            <div class="box box-success">

	           	<div class="box-header with-border admin-panel-success">

	                <b>{{ tr('categories') }}</b>

	                <a href="{{ route('admin.categories.create') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> {{ tr('add_category') }} </b> 
	                </a>

            	</div>
            
            	<div class="box-body">

					@if(count($categories) > 0)
						
						<div class="table table-responsive">
			              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

								<thead>
								    <tr>
								      <th>{{ tr('id') }}</th>
								      <th>{{ tr('category') }}</th>
								      <th>{{ tr('description') }}</th>
								      <th>{{ tr('sub_categories') }}</th>
								      <th>{{ tr('subscriptions') }}</th>
								      <th>{{ tr('picture') }}</th>
								      <th>{{ tr('status') }}</th>
								      <th>{{ tr('action') }}</th>
								    </tr>
								</thead>

								<tbody>
									@foreach($categories as $i => $category_details)

									    <tr>
									      	<td>{{ showEntries($_GET,$i+1) }}</td>
									      	<td>{{ $category_details->name }}</td>
									      	<td>{{ $category_details->description }}</td>
									      	<td>
									      		<a href="{{ route('admin.sub_categories.index' , ['category_id' => $category_details->id]) }}">
									      			{{ count($category_details->subCategory) }}
									      		</a>
									      	</td>
									      	<td>
									      		<a href="{{ route('admin.provider_subscriptions.index' , ['category_id' => $category_details->id]) }}">
									      			{{ $category_details->providerSubscription->count() }}
									      		</a>
									      	</td>
									      	<td>
			                                	<img style="height: 30px;" src="{{ $category_details->picture }}">
			                            	</td>

									     	<td>
									      		@if($category_details->status == COMMON_APPROVED)
									      			<span class="label label-success">{{ tr('approved') }}</span>
									       		@else
									       			<span class="label label-warning">{{ tr('pending') }}</span>
									       		@endif
									       	</td>
									      
									      	<td>

										      	<div class="dropdown">
													
													<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														{{ tr('action') }}
														<span class="caret"></span>
													</button>

													<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
														
														@if(Setting::get('admin_demo_control'))
															<li>
																<a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('edit') }}</b></a>
															</li>
															<li>
																<a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('delete') }}</b></a>
															</li>
														@else
															<li>
																<a href="{{ route('admin.categories.edit' , ['category_id' => $category_details->id ]) }}"><b>{{ tr('edit') }}</b></a>
															</li>
															<li>
																<a onclick="return confirm(&quot;{{  tr('admin_category_delete_confirmation' , $category_details->name)  }}&quot;)" href="{{ route('admin.categories.delete' , ['category_id' => $category_details->id] )  }}">
																	<b>{{ tr('delete') }}</b>
																</a>
															</li>
														@endif
														
														<li role="separator" class="divider"></li>

														@if($category_details->status == COMMON_APPROVED)
									                  		<li>
									                  			<a 	onclick="return confirm(&quot;{{ $category_details->name }} - {{ tr('category_decline_confirmation') }}&quot;);" href="{{  route('admin.categories.approve' , ['category_id' => $category_details->id ] ) }}">
									                  				<b>{{ tr('decline') }}</b>
									                  			</a>
									                  		</li>
									                  	@else
									                  		<li>
									                  			<a href="{{ route('admin.categories.approve' , ['category_id' => $category_details->id ] ) }}"><b>{{ tr('approve') }}</b></a>
									                  		</li>
									                  	@endif

														<li role="separator" class="divider"></li>

														<li>
															<a href="{{ route('admin.sub_categories.index' , array('category_id' => $category_details->id)) }}"><b>{{ tr('sub_categories') }}</b></a>
														</li>

														<li>
															<a href="{{ route('admin.provider_subscriptions.index' , ['category_id' => $category_details->id]) }}"><b>{{tr('provider_subscriptions')}}</b></a>
														</li>

													</ul>

												</div>

									      	</td>

									    </tr>

									@endforeach

								</tbody>

							</table>

							<div align="right">{{ $categories->links() }}</div>
						
						</div>

					@else

						<h3 class="no-result">{{ tr('no_result_found') }}</h3>

					@endif
			
            	</div>

         	</div>

        </div>

    </div>

@endsection
