@extends('layouts.admin')

@section('title', tr('sub_categories'))

@section('content-header')

{{ tr('sub_categories') }}

<a href="{{ route('admin.categories.index') }}">
	- {{ $category_details->name }}
</a>

@endsection

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

    <li><a href="{{ route('admin.categories.index') }}"><i class="fa fa-suitcase"></i> {{ tr('categories') }}</a></li>

    <li class="active"><i class="fa fa-suitcase"></i> {{ tr('sub_categories') }}</li>

@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">
	                
	                <b>{{ tr('sub_categories') }}</b>
	                
	                <a href="{{ route('admin.sub_categories.create') }}" style="float:right" class="btn btn-default">
	                	<b><i class="fa fa-plus"></i>{{ tr('add_sub_category') }} </b>
	                </a>
	            </div>
            
            	<div class="box-body">

					@if(count($sub_categories) > 0)

						<div class="table table-responsive">
			              	
			              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

								<thead>
								    <tr>
								      	<th>{{ tr('id') }}</th>
								      	<th>{{ tr('sub_category') }}</th>
								      	<th>{{ tr('description') }}</th>
								      	<th>{{ tr('price') }}</th>
								      	<th>{{ tr('status') }}</th>
								      	<th>{{ tr('image') }}</th>
								      	<th>{{ tr('action') }}</th>
								    </tr>
								</thead>

								<tbody>

									@foreach($sub_categories as $i => $sub_category_details)
										
									    <tr>
									      	<td>{{ showEntries($_GET,$i+1) }}</td>

									      	<td>{{ $sub_category_details->sub_category_name }}</td>

									      	<td>{{ $sub_category_details->description }}</td>

									      	<td>{{ $sub_category_details->price }}</td>

									      	<td>
									      		@if($sub_category_details->status == COMMON_APPROVED)
									      			<span class="label label-success">{{ tr('approved') }}</span>
									       		@else
									       			<span class="label label-warning">{{ tr('pending') }}</span>
									       		@endif
									       </td>
									      	
								      		<td>
			                                	<img style="height: 30px;" src="{{ $sub_category_details->picture }}">
			                            	</td>
									      	

										    <td>
		            							<ul class="admin-action btn btn-default">
		            								<li class="dropdown">
										                <a class="dropdown-toggle" data-toggle="dropdown" href="#">
										                  {{ tr('action') }} <span class="caret"></span>
										                </a>
										                <ul class="dropdown-menu">

										                  	<li role="presentation">
																@if(Setting::get('admin_demo_control'))
		                                                            <a role="button" href="javascript:;" class="btn disabled" style="text-align: left">{{ tr('edit') }}</a>
		                                                        @else
																	<li role="presentation">
												              		<a role="menuitem" tabindex="-1" href="{{ route('admin.sub_categories.edit' , ['sub_category_id' => $sub_category_details->id] ) }}">{{ tr('edit') }}
												              		</a></li>
																@endif


										                  	<li class="divider" role="presentation"></li>

										                  	@if($sub_category_details->status == COMMON_APPROVED)
										                  		<li>
										                  			<a href="{{ route('admin.sub_categories.status' , [sub_category_id' => $sub_category_details->id] ) }}">
										                  				<b>{{ tr('decline') }}</b>
										                  			</a>
										                  		</li>
										                  	@else
										                  		<li>
										                  			<a href="{{ route('admin.sub_categories.status' , ['sub_category_id' => $sub_category_details->id] ) }}">
										                  				<b>{{ tr('approve') }}</b>
										                  			</a>
										                  		</li>
										                  	@endif

										                  	<li role="presentation">

										                  		@if(Setting::get('admin_demo_control'))

											                  	 	<a role="button" href="javascript:;" class="btn disabled" style="text-align: left">{{ tr('delete') }}</a>

											                  	 @else

										                  			<a role="menuitem" onclick="return confirm('Are you sure?')" tabindex="-1" href="{{ route('admin.sub_categories.delete' , ['sub_category_id' => $sub_category_details->id] ) }}">{{ tr('delete') }}</a>
										                  		@endif

										                  	</li>

										                </ul>

		              								</li>

		            							</ul>

										    </td>

									    </tr>

									@endforeach

								</tbody>
								
							</table>

							<div align="right">{{ $sub_categories->links() }}</div>

						</div>

					@else

						<h3 class="no-result">{{ tr('no_sub_category_found') }}</h3>

					@endif
			
            	</div>
          	
          	</div>

        </div>

    </div>

@endsection
