@extends('layouts.admin')

@section('title',tr('add_coupon'))

@section('content-header',tr('add_coupon'))

@section('breadcrumb')

	<li><a href="{{route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

	<li><a href="{{route('admin.coupons.index') }}"><i class="fa fa-gift"></i>{{ tr('coupons') }}</a></li>

	<li class="active">{{ tr('add_coupon') }}</li>

@endsection

@section('content')

<div class="row">
    
	<div class="col-md-10 col-md-offset-1">
		@include('notification.notify')
	</div>
	<div class="col-md-10 col-md-offset-1">

        <div class="box box-success">

        	<div class="box-header with-border admin-panel-success">
        		
				<b style="font-size: 18px">{{ tr('add_coupon') }}</b>

				<a href="{{route('admin.coupons.index') }}" class="btn btn-warning pull-right"> <b> <i class="fa fa-eye"></i> {{ tr('view_coupons') }}</b></a>

			</div>
			
				@include('admin.coupons._form')

		</div>

	</div>
	
</div>
	
@endsection

@section('scripts')

<script>
	$('#coupon_code').keypress(function (e) {

	    var regex = new RegExp("^[a-zA-Z0-9]+$");
	    var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
	    if (regex.test(str)) {
	        return true;
	    }

	    e.preventDefault();
	    return false;
	});
</script>

@endsection



