@extends('layouts.admin')

@section('title',tr('coupons'))

@section('content-header',tr('coupons'))

@section('breadcrumb')

	<li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
	<li class="active">{{ tr('coupons') }}</li>

@endsection

@section('content')
	
	@include('notification.notify')
	
	<div class="row">
		
		<div class="col-xs-12">
	       
	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
            		
					<b style="font-size: 18px;">{{ tr('coupons') }}</b>

					<a href="{{ route('admin.coupons.create') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> {{ tr('add_coupon') }}</b>
	                </a>

				</div>

				<div class="box-body">

					@if(count($coupons) == 0)

						<h3 class="no-result">{{ tr('coupon_result_not_found_error') }}</h3>

					@else

						<table id = "datatable-withoutpagination" class="table table-bordered table-striped">
							
							<thead>
								<tr>
									<th>{{ tr('id') }}</th>
									<th>{{ tr('title') }}</th>
									<th>{{ tr('coupon_code') }}</th>
									<th>{{ tr('amount_type') }}</th>
									<th>{{ tr('amount') }}</th>
									<th>{{ tr('expiry_date') }}</th>
									<th>{{ tr('status') }}</th>
									<th>{{ tr('action') }}</th>
								</tr>
							</thead>

							<tbody>
							
								@foreach($coupons as $i=> $coupon_details)

								<tr>
									<td>{{ showEntries($_GET,$i+1) }}</td>

									<td><a href="{{ route('admin.coupons.view',['coupon_id' => $coupon_details->id] ) }}">{{ $coupon_details->title }}</a></td>

									<td>{{ $coupon_details->coupon_code }}</td>

									<td>
										@if($coupon_details->amount_type == 0)
											<span class="label label-primary">{{ tr('percentage') }}</span>
										@else
											<span class="label label-primary">{{ tr('absolute') }}</span>
										@endif
									</td>

									<td>
										@if($coupon_details->amount_type == PERCENTAGE)

											{{ $coupon_details->amount }} %

										@else

											{{ Setting::get('currency') }} {{ $coupon_details->amount }} 
										@endif

									</td>

									<td>
								
										{{ common_date($coupon_details->expiry_date , Auth::guard('admin')->user()->timezone , "d M y") }}
										
									</td>

									<td>
										@if($coupon_details->status == COUPON_APPROVED)
											<span class="label label-success">{{ tr('approved') }}</span>
										@else
											<span class="label label-warning">{{ tr('declined') }}</span>
										@endif
									</td>

									<td>

										<div class="dropdown @if($i < 2) dropdown @else dropup @endif">
											
											<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
	            								
												{{ tr('action') }}
												<span class="caret"></span>
											</button>

											<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
												<li>
													<a href="{{ route('admin.coupons.view',['coupon_id' => $coupon_details->id] ) }}">
														<b>{{ tr('view') }}</b>
													</a>
												</li>
												@if(Setting::get('admin_demo_control'))

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;"><b>{{ tr('edit') }}</b></a>
													</li>
													
													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;">
															<b>{{ tr('delete') }}</b>
														</a>
													</li>

													<li role="separator" class="divider"></li>

												@else

													<li>
														<a href="{{ route('admin.coupons.edit',['coupon_id' => $coupon_details->id] ) }}">
														<b>{{ tr('edit') }}</b>
														</a>
													</li>
													
													<li>
														<a href="{{ route('admin.coupons.delete',['coupon_id' => $coupon_details->id]) }}" onclick="return confirm(&quot;{{  tr('admin_coupon_delete_confirmation' , $coupon_details->title)  }}&quot;)" >
															<b>{{ tr('delete') }}</b>
														</a>
													</li>

													<li role="separator" class="divider"></li>

												@endif
																							
												<li>
													@if($coupon_details->status == 0)
														<a href="{{ route('admin.coupons.status',['coupon_id' => $coupon_details->id]) }}">
															<b> {{ tr('approve') }} </b> 
														</a>
													@else
														<a href="{{ route('admin.coupons.status',['coupon_id' => $coupon_details->id]) }}" onclick="return confirm(&quot;{{ $coupon_details->title }} - {{  tr('coupon_decline_confirmation')  }}&quot;);">
															<b> {{ tr('decline') }} </b> </a>
														</a>
													@endif
												</li>

											</ul>

										</div>

									</td>

								</tr>

								@endforeach

							</tbody>
						
						</table>
						
						<div align="right">{{ $coupons->links() }}</div>	

					@endif

				</div>

			</div>

		</div>

	</div>
@endsection

